/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License)
  * or the CeCILL as published by CeCILL.info (version 2 of the License).
  *
  * There are special exceptions to the terms and conditions of the
  * licenses as they are applied to this program. See LICENSE.txt in
  * the directory of this program distribution.
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.system.sysconf.helper;

import java.util.Map.Entry;
import java.util.stream.Collectors;

import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.hornetq.client.Shared;
import net.bluemind.system.api.IInternalCredentials;
import net.bluemind.system.api.ISystemConfiguration;
import net.bluemind.system.api.SysConfKeys;
import net.bluemind.system.api.SystemConf;

public class SysConfHelper {
	private SysConfHelper() {
	}

	/**
	 * Use to get all systemconf, including obfuscated values - retrieved from
	 * credentials service
	 * 
	 * @param credentials
	 * @param sysconf
	 * @return
	 */
	public static SystemConf getPlainSystemConf(IServiceProvider sysprov) {
		SystemConf sysconf = sysprov.instance(ISystemConfiguration.class).getValues();
		IInternalCredentials credentials = sysprov.instance(IInternalCredentials.class, "global.virt");

		return SystemConf.create(sysconf.values.entrySet().stream().map(e -> {
			if (!SysConfKeys.obfuscateOnGet(e.getKey())) {
				return e;
			}

			e.setValue(credentials.getDomainCredentialById(e.getKey()));
			return e;
		}).collect(Collectors.toMap(Entry::getKey, Entry::getValue)));
	}

	public static SystemConf fromSharedMap() {
		return SystemConf.create(Shared.mapSysconf().asMap());
	}
}
