/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.attachment.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class AttachmentEndpointPromise implements net.bluemind.attachment.api.IAttachmentPromise {

	private net.bluemind.attachment.api.IAttachmentAsync impl;

	public AttachmentEndpointPromise(net.bluemind.attachment.api.IAttachmentAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.attachment.api.Configuration> getConfiguration() {
		
		CompletableFuture<net.bluemind.attachment.api.Configuration> ret = new CompletableFuture<net.bluemind.attachment.api.Configuration>();
		AsyncHandler<net.bluemind.attachment.api.Configuration> handler = new AsyncHandler<net.bluemind.attachment.api.Configuration>() {
			public void success(net.bluemind.attachment.api.Configuration value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getConfiguration( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.attachment.api.AttachedFile> share(String name ,  Stream document  ) {
		
		CompletableFuture<net.bluemind.attachment.api.AttachedFile> ret = new CompletableFuture<net.bluemind.attachment.api.AttachedFile>();
		AsyncHandler<net.bluemind.attachment.api.AttachedFile> handler = new AsyncHandler<net.bluemind.attachment.api.AttachedFile>() {
			public void success(net.bluemind.attachment.api.AttachedFile value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.share(name, document,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.attachment.api.AttachedFile> shareDedup(String extension ,  Stream document  ) {
		
		CompletableFuture<net.bluemind.attachment.api.AttachedFile> ret = new CompletableFuture<net.bluemind.attachment.api.AttachedFile>();
		AsyncHandler<net.bluemind.attachment.api.AttachedFile> handler = new AsyncHandler<net.bluemind.attachment.api.AttachedFile>() {
			public void success(net.bluemind.attachment.api.AttachedFile value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.shareDedup(extension, document,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> unShare(String url  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.unShare(url,  handler);
		return ret;
	}

}
