/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class EmailGwtSerDer implements GwtSerDer<net.bluemind.core.api.Email> {

	public EmailGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.api.Email deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.api.Email ret = new net.bluemind.core.api.Email();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.api.Email ret, JSONObject json) {
		JSONValue addressJSON = json.get("address");
		ret.address =  GwtSerDerUtils.STRING.deserialize(addressJSON);
		JSONValue allAliasesJSON = json.get("allAliases");
		ret.allAliases =  GwtSerDerUtils.BOOLEAN.deserialize(allAliasesJSON);
		JSONValue isDefaultJSON = json.get("isDefault");
		ret.isDefault =  GwtSerDerUtils.BOOLEAN.deserialize(isDefaultJSON);
	}

	public void deserializeTo(net.bluemind.core.api.Email ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("address")) {
			JSONValue addressJSON = json.get("address");
			ret.address =  GwtSerDerUtils.STRING.deserialize(addressJSON);
		}
		if (!childPropertiesToIgnore.contains("allAliases")) {
			JSONValue allAliasesJSON = json.get("allAliases");
			ret.allAliases =  GwtSerDerUtils.BOOLEAN.deserialize(allAliasesJSON);
		}
		if (!childPropertiesToIgnore.contains("isDefault")) {
			JSONValue isDefaultJSON = json.get("isDefault");
			ret.isDefault =  GwtSerDerUtils.BOOLEAN.deserialize(isDefaultJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.api.Email o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.api.Email o, JSONObject ret) {

		ret.put("address",  GwtSerDerUtils.STRING.serialize( o.address ));
		ret.put("allAliases",  GwtSerDerUtils.BOOLEAN.serialize( o.allAliases ));
		ret.put("isDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.isDefault ));
	}

	public void serializeTo(net.bluemind.core.api.Email o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("address")) {
			ret.put("address",  GwtSerDerUtils.STRING.serialize( o.address ));
		}
		if (!childPropertiesToIgnore.contains("allAliases")) {
			ret.put("allAliases",  GwtSerDerUtils.BOOLEAN.serialize( o.allAliases ));
		}
		if (!childPropertiesToIgnore.contains("isDefault")) {
			ret.put("isDefault",  GwtSerDerUtils.BOOLEAN.serialize( o.isDefault ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}