/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.user.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsUser extends net.bluemind.directory.api.gwt.js.JsDirBaseValue  {

	protected JsUser() {}

	public final native String getLogin()
	/*-{
	return this["login"];
	}-*/;

	public final native void setLogin(String login)
	/*-{
       this["login"] = login;
	}-*/;

	public final native String getPassword()
	/*-{
	return this["password"];
	}-*/;

	public final native void setPassword(String password)
	/*-{
       this["password"] = password;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getPasswordLastChange()
	/*-{
       if(this["passwordLastChange"]) {
          return new Date(this["passwordLastChange"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setPasswordLastChange(com.google.gwt.core.client.JsDate passwordLastChange)
	/*-{
       this["passwordLastChange"] =  ( passwordLastChange != null) ? passwordLastChange.getTime() : null;
	}-*/;

	public final native boolean getPasswordMustChange()
	/*-{
	return this["passwordMustChange"];
	}-*/;

	public final native void setPasswordMustChange(boolean passwordMustChange)
	/*-{
       this["passwordMustChange"] = passwordMustChange;
	}-*/;

	public final native boolean getPasswordNeverExpires()
	/*-{
	return this["passwordNeverExpires"];
	}-*/;

	public final native void setPasswordNeverExpires(boolean passwordNeverExpires)
	/*-{
       this["passwordNeverExpires"] = passwordNeverExpires;
	}-*/;

	public final native net.bluemind.addressbook.api.gwt.js.JsVCard getContactInfos()
	/*-{
	return this["contactInfos"];
	}-*/;

	public final native void setContactInfos(net.bluemind.addressbook.api.gwt.js.JsVCard contactInfos)
	/*-{
       this["contactInfos"] = contactInfos;
	}-*/;

	public final native net.bluemind.mailbox.api.gwt.js.JsMailboxRouting getRouting()
	/*-{
	return this["routing"];
	}-*/;

	public final native void setRouting(net.bluemind.mailbox.api.gwt.js.JsMailboxRouting routing)
	/*-{
       this["routing"] = routing;
	}-*/;

	public final native net.bluemind.directory.api.gwt.js.JsBaseDirEntryAccountType getAccountType()
	/*-{
	return this["accountType"];
	}-*/;

	public final native void setAccountType(net.bluemind.directory.api.gwt.js.JsBaseDirEntryAccountType accountType)
	/*-{
       this["accountType"] = accountType;
	}-*/;

	public final native boolean getLoginCaps()
	/*-{
	return this["loginCaps"];
	}-*/;

	public final native void setLoginCaps(boolean loginCaps)
	/*-{
       this["loginCaps"] = loginCaps;
	}-*/;

	public final native Integer getQuota()
	/*-{
	return ( this["quota"] != null) ? @java.lang.Integer::new(I)(this["quota"]) : null;
	}-*/;

	public final native void setQuota(Integer quota)
	/*-{
       this["quota"] =  ( quota != null) ? quota.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native String getMailboxCopyGuid()
	/*-{
	return this["mailboxCopyGuid"];
	}-*/;

	public final native void setMailboxCopyGuid(String mailboxCopyGuid)
	/*-{
       this["mailboxCopyGuid"] = mailboxCopyGuid;
	}-*/;

	public final native net.bluemind.core.commons.gwt.JsMapStringString getProperties()
	/*-{
	return this["properties"];
	}-*/;

	public final native void setProperties(net.bluemind.core.commons.gwt.JsMapStringString properties)
	/*-{
       this["properties"] = properties;
	}-*/;

	public static native  JsUser create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}