/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class UserGwtEndpoint implements net.bluemind.user.api.IUserAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public UserGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/users/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public UserGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void allUids(final AsyncHandler<List<String>> handler) {
		String postUri = "/_alluids";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void byEmail(String email, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler) {
		String postUri = "/byEmail/{email}";

		postUri = postUri.replace("{email}", URL.encodePathSegment(""+email));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.UserGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void byExtId(String extid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler) {
		String postUri = "/byExtId/{extid}";

		postUri = postUri.replace("{extid}", URL.encodePathSegment(""+extid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.UserGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void byLogin(String login, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler) {
		String postUri = "/byLogin/{login}";

		postUri = postUri.replace("{login}", URL.encodePathSegment(""+login));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.UserGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void create(String uid, net.bluemind.user.api.User user, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.user.api.gwt.serder.UserGwtSerDer().serialize( user);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void createWithExtId(String uid, String extid, net.bluemind.user.api.User user, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/{extid}/createwithextid";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		postUri = postUri.replace("{extid}", URL.encodePathSegment(""+extid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.user.api.gwt.serder.UserGwtSerDer().serialize( user);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void delete(String uid, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.task.api.TaskRef>(handler) {
			@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void deletePhoto(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/photo";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void enablePerUserLog(String userUid, String endpoint, boolean enable, final AsyncHandler<Void> handler) {
		String postUri = "/{userUid}/_logging/{endpoint}";

		postUri = postUri.replace("{userUid}", URL.encodePathSegment(""+userUid));
		postUri = postUri.replace("{endpoint}", URL.encodePathSegment(""+endpoint));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.BOOLEAN.serialize( enable);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler) {
		String postUri = "/{uid}/complete";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.UserGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getIcon(String uid, final AsyncHandler<byte[]> handler) {
		String postUri = "/{uid}/icon";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<byte[]>(handler) {
			@Override
			protected byte[] handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ByteArraySerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getLight(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler) {
		String postUri = "/{uid}/light";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.UserGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getLocale(String uid, final AsyncHandler<String> handler) {
		String postUri = "/{uid}/locale";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<String>(handler) {
			@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getMultipleVcardOnly(List<String> uids, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>> handler) {
		String postUri = "/_mgetvcardonly";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( uids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.user.api.gwt.serder.UserGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getPhoto(String uid, final AsyncHandler<byte[]> handler) {
		String postUri = "/{uid}/photo";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<byte[]>(handler) {
			@Override
			protected byte[] handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ByteArraySerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getResolvedRoles(String uid, final AsyncHandler<Set<String>> handler) {
		String postUri = "/{uid}/roles_resolved";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Set<String>>(handler) {
			@Override
			protected Set<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getRoles(String uid, final AsyncHandler<Set<String>> handler) {
		String postUri = "/{uid}/roles";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Set<String>>(handler) {
			@Override
			protected Set<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getUsersWithRoles(List<String> roles, final AsyncHandler<Set<String>> handler) {
		String postUri = "/_roleusers";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( roles);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Set<String>>(handler) {
			@Override
			protected Set<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getVCard(String uid, final AsyncHandler<net.bluemind.addressbook.api.VCard> handler) {
		String postUri = "/{uid}/vcard";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.addressbook.api.VCard>(handler) {
			@Override
			protected net.bluemind.addressbook.api.VCard handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void memberOf(String uid, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> handler) {
		String postUri = "/{uid}/groups";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.group.api.gwt.serder.GroupGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void memberOfGroups(String uid, final AsyncHandler<List<String>> handler) {
		String postUri = "/{uid}/groupUids";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void setExtId(String uid, String arg1, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/_extId";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void setPassword(String uid, net.bluemind.user.api.ChangePassword password, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/password_";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.user.api.gwt.serder.ChangePasswordGwtSerDer().serialize( password);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void setPhoto(String uid, byte[] arg1, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/photo";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ByteArraySerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void setRoles(String uid, Set<String> roles, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/roles";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( roles);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void update(String uid, net.bluemind.user.api.User user, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.user.api.gwt.serder.UserGwtSerDer().serialize( user);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void updateAccountType(String uid, net.bluemind.directory.api.BaseDirEntry.AccountType accountType, final AsyncHandler<Void> handler) {
		String postUri = "/_updateAccountType/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.directory.api.gwt.serder.BaseDirEntryAccountTypeGwtSerDer().serialize( accountType);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void updateVCard(String uid, net.bluemind.addressbook.api.VCard userVCard, final AsyncHandler<Void> handler) {
		String postUri = "/{uid}/vcard";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().serialize( userVCard);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.user.api.IUserPromise promiseApi() {
		return new UserEndpointPromise(this);
	}
}
