/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class SharedMailboxEndpointPromise implements net.bluemind.user.api.ISharedMailboxPromise {

	private net.bluemind.user.api.ISharedMailboxAsync impl;

	public SharedMailboxEndpointPromise(net.bluemind.user.api.ISharedMailboxAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<String>> allUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> byEmail(String email  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byEmail(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> byName(String login  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byName(login,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> delete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> getLight(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.SharedMailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getLight(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.addressbook.api.VCard> getVCard(String uid  ) {
		
		CompletableFuture<net.bluemind.addressbook.api.VCard> ret = new CompletableFuture<net.bluemind.addressbook.api.VCard>();
		AsyncHandler<net.bluemind.addressbook.api.VCard> handler = new AsyncHandler<net.bluemind.addressbook.api.VCard>() {
			public void success(net.bluemind.addressbook.api.VCard value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVCard(uid,  handler);
		return ret;
	}

}
