package net.bluemind.memory.pool.api;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public interface MemoryMappedPool extends AutoCloseable {

	IChunk allocateFrom(InputStream in, int maxSize) throws IOException;

	IChunk allocateFrom(byte[] bytes) throws IOException;

	IChunk allocateFrom(ByteBuffer bytes) throws IOException;

	IWritableChunk allocateEmpty(int maxSize) throws IOException;

	PoolStats getStats();

	void cleanup();

	public static class PoolStats {
		private final int totalSegments;
		private final int activeSegments;
		private final long totalSize;
		private final long usedSize;
		private final int totalChunks;
		private final long segmentId;

		public PoolStats(int totalSegments, int activeSegments, long totalSize, long usedSize, int totalChunks,
				long segmentId) {
			this.totalSegments = totalSegments;
			this.activeSegments = activeSegments;
			this.totalSize = totalSize;
			this.usedSize = usedSize;
			this.totalChunks = totalChunks;
			this.segmentId = segmentId;
		}

		public int getTotalSegments() {
			return totalSegments;
		}

		public int getActiveSegments() {
			return activeSegments;
		}

		public long getTotalSize() {
			return totalSize;
		}

		public long getUsedSize() {
			return usedSize;
		}

		public int getTotalChunks() {
			return totalChunks;
		}

		public double getUsage() {
			return totalSize > 0 ? (double) usedSize / totalSize : 0;
		}

		@Override
		public String toString() {
			return String.format("PoolStats[segments=%d/%d, size=%d/%d (%.1f%%), chunks=%d, sid=%d]", activeSegments,
					totalSegments, usedSize, totalSize, getUsage() * 100, totalChunks, segmentId);
		}
	}
}
