package net.bluemind.webmodule.server.resources;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

import org.osgi.framework.Bundle;

class LazyWebResource extends AbstractWebResource implements WebResource {
	private Set<String> loaded;
	public LazyWebResource(Bundle bundle) {
		super(bundle);
		loaded = new HashSet<>();
	}

	public Optional<Path> getResource(String path) {
		if (!loaded.contains(path) && !super.hasResource(path)) {
			loaded.add(path);
			load(resolve(path));
		}
		return super.getResource(path);
	}

}
