package net.bluemind.webmodule.server.handlers;

import java.util.List;
import java.util.Set;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodule.server.handlers.internal.AssetUtils;

public class ResourceListHandler implements IWebModuleConsumer, Handler<HttpServerRequest> {
	private WebModule module;

	@Override
	public void handle(HttpServerRequest request) {
		List<String> assets = AssetUtils.getAssetsList(module);

		Set<String> handlers = module.handlers.keySet();
		var resource = new Resource(assets, handlers);

		HttpServerResponse resp = request.response();

		resp.putHeader("Content-Type", "application/json");
		resp.setStatusCode(200);
		resp.end(JsonUtils.asString(resource));
	}

	@Override
	public void setModule(WebModule module) {
		this.module = module;
	}

    public record Resource(List<String> assets, Set<String> handlers) {}
}
