/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.conditions.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleFilterRangeGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange> {

	private net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterGwtSerDer parent = new  net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleFilterGwtSerDer();
	public MailFilterRuleFilterRangeGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange ret = new net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue lowerBoundJSON = json.get("lowerBound");
		ret.lowerBound =  GwtSerDerUtils.STRING.deserialize(lowerBoundJSON);
		JSONValue upperBoundJSON = json.get("upperBound");
		ret.upperBound =  GwtSerDerUtils.STRING.deserialize(upperBoundJSON);
		JSONValue inclusiveJSON = json.get("inclusive");
		ret.inclusive =  GwtSerDerUtils.BOOLEAN.deserialize(inclusiveJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("lowerBound")) {
			JSONValue lowerBoundJSON = json.get("lowerBound");
			ret.lowerBound =  GwtSerDerUtils.STRING.deserialize(lowerBoundJSON);
		}
		if (!childPropertiesToIgnore.contains("upperBound")) {
			JSONValue upperBoundJSON = json.get("upperBound");
			ret.upperBound =  GwtSerDerUtils.STRING.deserialize(upperBoundJSON);
		}
		if (!childPropertiesToIgnore.contains("inclusive")) {
			JSONValue inclusiveJSON = json.get("inclusive");
			ret.inclusive =  GwtSerDerUtils.BOOLEAN.deserialize(inclusiveJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("lowerBound",  GwtSerDerUtils.STRING.serialize( o.lowerBound ));
		ret.put("upperBound",  GwtSerDerUtils.STRING.serialize( o.upperBound ));
		ret.put("inclusive",  GwtSerDerUtils.BOOLEAN.serialize( o.inclusive ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterRange o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("lowerBound")) {
			ret.put("lowerBound",  GwtSerDerUtils.STRING.serialize( o.lowerBound ));
		}
		if (!childPropertiesToIgnore.contains("upperBound")) {
			ret.put("upperBound",  GwtSerDerUtils.STRING.serialize( o.upperBound ));
		}
		if (!childPropertiesToIgnore.contains("inclusive")) {
			ret.put("inclusive",  GwtSerDerUtils.BOOLEAN.serialize( o.inclusive ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}