/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailboxType extends JavaScriptObject {

	protected JsMailboxType() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsMailboxType user()
	/*-{
		return "user";
	}-*/;

	public static final native JsMailboxType mailshare()
	/*-{
		return "mailshare";
	}-*/;

	public static final native JsMailboxType group()
	/*-{
		return "group";
	}-*/;

	public static final native JsMailboxType resource()
	/*-{
		return "resource";
	}-*/;

	public static final JsMailboxType create(net.bluemind.mailbox.api.Mailbox.Type value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case user:
				return user();
			case mailshare:
				return mailshare();
			case group:
				return group();
			case resource:
				return resource();
			default:
				return null;
			}
		}
	}
}