/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailboxConfig extends JavaScriptObject {

	protected JsMailboxConfig() {}

	public final native Integer getQuota()
	/*-{
	return ( this["quota"] != null) ? @java.lang.Integer::new(I)(this["quota"]) : null;
	}-*/;

	public final native void setQuota(Integer quota)
	/*-{
       this["quota"] =  ( quota != null) ? quota.@java.lang.Integer::intValue()() : null;
	}-*/;

	public final native Integer getMessageMaxSize()
	/*-{
	return ( this["messageMaxSize"] != null) ? @java.lang.Integer::new(I)(this["messageMaxSize"]) : null;
	}-*/;

	public final native void setMessageMaxSize(Integer messageMaxSize)
	/*-{
       this["messageMaxSize"] =  ( messageMaxSize != null) ? messageMaxSize.@java.lang.Integer::intValue()() : null;
	}-*/;

	public static native  JsMailboxConfig create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}