/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailboxesEndpointPromise implements net.bluemind.mailbox.api.IMailboxesPromise {

	private net.bluemind.mailbox.api.IMailboxesAsync impl;

	public MailboxesEndpointPromise(net.bluemind.mailbox.api.IMailboxesAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Long> addDomainRule(net.bluemind.mailbox.api.rules.MailFilterRule rule  ) {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.addDomainRule(rule,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Long> addMailboxRule(String mailboxUid ,  net.bluemind.mailbox.api.rules.MailFilterRule rule  ) {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.addMailboxRule(mailboxUid, rule,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Long> addMailboxRuleRelative(String mailboxUid ,  net.bluemind.mailbox.api.rules.RuleMoveRelativePosition position ,  long anchorId ,  net.bluemind.mailbox.api.rules.MailFilterRule rule  ) {
		
		CompletableFuture<Long> ret = new CompletableFuture<Long>();
		AsyncHandler<Long> handler = new AsyncHandler<Long>() {
			public void success(Long value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.addMailboxRuleRelative(mailboxUid, position, anchorId, rule,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> byEmail(String email  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byEmail(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> byName(String name  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byName(name,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> byRouting(net.bluemind.mailbox.api.Mailbox.Routing email  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byRouting(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.mailbox.api.Mailbox mailbox  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, mailbox,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteDomainRule(long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteDomainRule(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteMailboxRule(String mailboxUid ,  long id  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteMailboxRule(mailboxUid, id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailFilter> getDomainFilter() {
		
		CompletableFuture<net.bluemind.mailbox.api.MailFilter> ret = new CompletableFuture<net.bluemind.mailbox.api.MailFilter>();
		AsyncHandler<net.bluemind.mailbox.api.MailFilter> handler = new AsyncHandler<net.bluemind.mailbox.api.MailFilter>() {
			public void success(net.bluemind.mailbox.api.MailFilter value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getDomainFilter( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.rules.MailFilterRule> getDomainRule(long id  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.rules.MailFilterRule> ret = new CompletableFuture<net.bluemind.mailbox.api.rules.MailFilterRule>();
		AsyncHandler<net.bluemind.mailbox.api.rules.MailFilterRule> handler = new AsyncHandler<net.bluemind.mailbox.api.rules.MailFilterRule>() {
			public void success(net.bluemind.mailbox.api.rules.MailFilterRule value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getDomainRule(id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>> getDomainRules() {
		
		CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>> ret = new CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>>();
		AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>> handler = new AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>>() {
			public void success(List<net.bluemind.mailbox.api.rules.MailFilterRule> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getDomainRules( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>> getMailboxAccessControlList(String mailboxUid  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>> ret = new CompletableFuture<List<net.bluemind.core.container.model.acl.AccessControlEntry>>();
		AsyncHandler<List<net.bluemind.core.container.model.acl.AccessControlEntry>> handler = new AsyncHandler<List<net.bluemind.core.container.model.acl.AccessControlEntry>>() {
			public void success(List<net.bluemind.core.container.model.acl.AccessControlEntry> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxAccessControlList(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailboxConfig> getMailboxConfig(String uid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.MailboxConfig> ret = new CompletableFuture<net.bluemind.mailbox.api.MailboxConfig>();
		AsyncHandler<net.bluemind.mailbox.api.MailboxConfig> handler = new AsyncHandler<net.bluemind.mailbox.api.MailboxConfig>() {
			public void success(net.bluemind.mailbox.api.MailboxConfig value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxConfig(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.rules.DelegationRule> getMailboxDelegationRule(String mailboxUid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.rules.DelegationRule> ret = new CompletableFuture<net.bluemind.mailbox.api.rules.DelegationRule>();
		AsyncHandler<net.bluemind.mailbox.api.rules.DelegationRule> handler = new AsyncHandler<net.bluemind.mailbox.api.rules.DelegationRule>() {
			public void success(net.bluemind.mailbox.api.rules.DelegationRule value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxDelegationRule(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailFilter> getMailboxFilter(String mailboxUid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.MailFilter> ret = new CompletableFuture<net.bluemind.mailbox.api.MailFilter>();
		AsyncHandler<net.bluemind.mailbox.api.MailFilter> handler = new AsyncHandler<net.bluemind.mailbox.api.MailFilter>() {
			public void success(net.bluemind.mailbox.api.MailFilter value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxFilter(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailFilter.Forwarding> getMailboxForwarding(String mailboxUid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.MailFilter.Forwarding> ret = new CompletableFuture<net.bluemind.mailbox.api.MailFilter.Forwarding>();
		AsyncHandler<net.bluemind.mailbox.api.MailFilter.Forwarding> handler = new AsyncHandler<net.bluemind.mailbox.api.MailFilter.Forwarding>() {
			public void success(net.bluemind.mailbox.api.MailFilter.Forwarding value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxForwarding(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailboxQuota> getMailboxQuota(String uid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.MailboxQuota> ret = new CompletableFuture<net.bluemind.mailbox.api.MailboxQuota>();
		AsyncHandler<net.bluemind.mailbox.api.MailboxQuota> handler = new AsyncHandler<net.bluemind.mailbox.api.MailboxQuota>() {
			public void success(net.bluemind.mailbox.api.MailboxQuota value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxQuota(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.rules.MailFilterRule> getMailboxRule(String mailboxUid ,  long id  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.rules.MailFilterRule> ret = new CompletableFuture<net.bluemind.mailbox.api.rules.MailFilterRule>();
		AsyncHandler<net.bluemind.mailbox.api.rules.MailFilterRule> handler = new AsyncHandler<net.bluemind.mailbox.api.rules.MailFilterRule>() {
			public void success(net.bluemind.mailbox.api.rules.MailFilterRule value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxRule(mailboxUid, id,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>> getMailboxRules(String mailboxUid  ) {
		
		CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>> ret = new CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>>();
		AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>> handler = new AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>>() {
			public void success(List<net.bluemind.mailbox.api.rules.MailFilterRule> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxRules(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>> getMailboxRulesByClient(String mailboxUid ,  String client  ) {
		
		CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>> ret = new CompletableFuture<List<net.bluemind.mailbox.api.rules.MailFilterRule>>();
		AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>> handler = new AsyncHandler<List<net.bluemind.mailbox.api.rules.MailFilterRule>>() {
			public void success(List<net.bluemind.mailbox.api.rules.MailFilterRule> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxRulesByClient(mailboxUid, client,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailbox.api.MailFilter.Vacation> getMailboxVacation(String mailboxUid  ) {
		
		CompletableFuture<net.bluemind.mailbox.api.MailFilter.Vacation> ret = new CompletableFuture<net.bluemind.mailbox.api.MailFilter.Vacation>();
		AsyncHandler<net.bluemind.mailbox.api.MailFilter.Vacation> handler = new AsyncHandler<net.bluemind.mailbox.api.MailFilter.Vacation>() {
			public void success(net.bluemind.mailbox.api.MailFilter.Vacation value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getMailboxVacation(mailboxUid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Integer> getUnreadMessagesCount() {
		
		CompletableFuture<Integer> ret = new CompletableFuture<Integer>();
		AsyncHandler<Integer> handler = new AsyncHandler<Integer>() {
			public void success(Integer value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getUnreadMessagesCount( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> list() {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.list( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> listUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> moveMailboxRule(String mailboxUid ,  long id ,  net.bluemind.mailbox.api.rules.RuleMoveDirection direction  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.moveMailboxRule(mailboxUid, id, direction,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> moveMailboxRuleRelative(String mailboxUid ,  long id ,  net.bluemind.mailbox.api.rules.RuleMoveRelativePosition position ,  long anchorId  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.moveMailboxRuleRelative(mailboxUid, id, position, anchorId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> multipleGet(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGet(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setDomainFilter(net.bluemind.mailbox.api.MailFilter filter  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setDomainFilter(filter,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setMailboxAccessControlList(String mailboxUid ,  List<net.bluemind.core.container.model.acl.AccessControlEntry> accessControlEntries  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setMailboxAccessControlList(mailboxUid, accessControlEntries,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setMailboxDelegationRule(String mailboxUid ,  net.bluemind.mailbox.api.rules.DelegationRule delegationRule  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setMailboxDelegationRule(mailboxUid, delegationRule,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setMailboxFilter(String mailboxUid ,  net.bluemind.mailbox.api.MailFilter filter  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setMailboxFilter(mailboxUid, filter,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setMailboxForwarding(String mailboxUid ,  net.bluemind.mailbox.api.MailFilter.Forwarding forwarding  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setMailboxForwarding(mailboxUid, forwarding,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setMailboxVacation(String mailboxUid ,  net.bluemind.mailbox.api.MailFilter.Vacation vacation  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setMailboxVacation(mailboxUid, vacation,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.mailbox.api.Mailbox mailbox  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, mailbox,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateDomainRule(long id ,  net.bluemind.mailbox.api.rules.MailFilterRule rule  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateDomainRule(id, rule,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateMailboxRule(String mailboxUid ,  long id ,  net.bluemind.mailbox.api.rules.MailFilterRule rule  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateMailboxRule(mailboxUid, id, rule,  handler);
		return ret;
	}

}
