/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.impl;

import com.netflix.spectator.impl.PatternMatcher;
import com.netflix.spectator.impl.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public interface PatternExpr {
    public boolean matches(String var1);

    public PatternExpr ignoreCase();

    default public String toQueryString(Encoder encoder) {
        StringBuilder builder = new StringBuilder();
        this.buildQueryString(encoder, builder);
        return builder.toString();
    }

    default public void buildQueryString(Encoder encoder, StringBuilder builder) {
        if (this instanceof Regex) {
            Regex re = (Regex)this;
            builder.append(encoder.regex(re.matcher()));
        } else if (this instanceof And) {
            List<PatternExpr> exprs = ((And)this).exprs();
            int size = exprs.size();
            if (size == 1) {
                exprs.get(0).buildQueryString(encoder, builder);
            } else if (size > 1) {
                builder.append(encoder.startAnd());
                exprs.get(0).buildQueryString(encoder, builder);
                for (int i = 1; i < size; ++i) {
                    builder.append(encoder.separatorAnd());
                    exprs.get(i).buildQueryString(encoder, builder);
                }
                builder.append(encoder.endAnd());
            }
        } else if (this instanceof Or) {
            List<PatternExpr> exprs = ((Or)this).exprs();
            int size = exprs.size();
            if (size == 1) {
                exprs.get(0).buildQueryString(encoder, builder);
            } else if (size > 1) {
                builder.append(encoder.startOr());
                exprs.get(0).buildQueryString(encoder, builder);
                for (int i = 1; i < size; ++i) {
                    builder.append(encoder.separatorOr());
                    exprs.get(i).buildQueryString(encoder, builder);
                }
                builder.append(encoder.endOr());
            }
        } else if (this instanceof Not) {
            builder.append(encoder.startNot());
            ((Not)this).expr().buildQueryString(encoder, builder);
            builder.append(encoder.endNot());
        }
    }

    public static PatternExpr simple(PatternMatcher matcher) {
        return new Regex(matcher);
    }

    public static PatternExpr and(List<PatternExpr> exprs) {
        if (exprs == null) {
            return null;
        }
        int size = exprs.size();
        Preconditions.checkArg(size > 0, "exprs list cannot be empty");
        return size == 1 ? exprs.get(0) : new And(exprs);
    }

    public static PatternExpr or(List<PatternExpr> exprs) {
        if (exprs == null) {
            return null;
        }
        int size = exprs.size();
        Preconditions.checkArg(size > 0, "exprs list cannot be empty");
        return size == 1 ? exprs.get(0) : new Or(exprs);
    }

    public static PatternExpr not(PatternExpr expr) {
        return new Not(expr);
    }

    public static final class Not
    implements PatternExpr {
        private final PatternExpr expr;

        Not(PatternExpr expr) {
            this.expr = Preconditions.checkNotNull(expr, "expr");
        }

        public PatternExpr expr() {
            return this.expr;
        }

        @Override
        public boolean matches(String str) {
            return !this.expr.matches(str);
        }

        @Override
        public PatternExpr ignoreCase() {
            return new Not(this.expr.ignoreCase());
        }

        public String toString() {
            return "NOT " + this.expr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Not)) {
                return false;
            }
            Not not = (Not)o;
            return this.expr.equals(not.expr);
        }

        public int hashCode() {
            return Objects.hash(this.expr);
        }
    }

    public static final class Or
    implements PatternExpr {
        private final List<PatternExpr> exprs;

        Or(List<PatternExpr> exprs) {
            this.exprs = Preconditions.checkNotNull(exprs, "exprs");
        }

        public List<PatternExpr> exprs() {
            return this.exprs;
        }

        @Override
        public boolean matches(String str) {
            for (PatternExpr expr : this.exprs) {
                if (!expr.matches(str)) continue;
                return true;
            }
            return false;
        }

        @Override
        public PatternExpr ignoreCase() {
            return new Or(this.exprs.stream().map(PatternExpr::ignoreCase).collect(Collectors.toList()));
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(" OR ", "(", ")");
            this.exprs.forEach(expr -> joiner.add(expr.toString()));
            return joiner.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Or)) {
                return false;
            }
            Or or = (Or)o;
            return this.exprs.equals(or.exprs);
        }

        public int hashCode() {
            return Objects.hash(this.exprs);
        }
    }

    public static final class And
    implements PatternExpr {
        private final List<PatternExpr> exprs;

        And(List<PatternExpr> exprs) {
            this.exprs = Preconditions.checkNotNull(exprs, "exprs");
        }

        public List<PatternExpr> exprs() {
            return this.exprs;
        }

        @Override
        public boolean matches(String str) {
            for (PatternExpr expr : this.exprs) {
                if (expr.matches(str)) continue;
                return false;
            }
            return true;
        }

        @Override
        public PatternExpr ignoreCase() {
            return new And(this.exprs.stream().map(PatternExpr::ignoreCase).collect(Collectors.toList()));
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(" AND ", "(", ")");
            this.exprs.forEach(expr -> joiner.add(expr.toString()));
            return joiner.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof And)) {
                return false;
            }
            And and = (And)o;
            return this.exprs.equals(and.exprs);
        }

        public int hashCode() {
            return Objects.hash(this.exprs);
        }
    }

    public static final class Regex
    implements PatternExpr {
        private final PatternMatcher matcher;

        Regex(PatternMatcher matcher) {
            this.matcher = Preconditions.checkNotNull(matcher, "matcher");
        }

        public PatternMatcher matcher() {
            return this.matcher;
        }

        @Override
        public boolean matches(String str) {
            return this.matcher.matches(str);
        }

        @Override
        public PatternExpr ignoreCase() {
            return new Regex(this.matcher.ignoreCase());
        }

        public String toString() {
            return "'" + this.matcher + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Regex)) {
                return false;
            }
            Regex regex = (Regex)o;
            return this.matcher.equals(regex.matcher);
        }

        public int hashCode() {
            return Objects.hash(this.matcher);
        }
    }

    public static interface Encoder {
        public String regex(PatternMatcher var1);

        public String startAnd();

        public String separatorAnd();

        public String endAnd();

        public String startOr();

        public String separatorOr();

        public String endOr();

        public String startNot();

        public String endNot();
    }
}

