/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.login;

import freemarker.template.Configuration;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.bluemind.config.Token;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.BMVersion;
import net.bluemind.core.rest.http.HttpClientProvider;
import net.bluemind.core.rest.http.ILocator;
import net.bluemind.core.rest.http.ITaggedServiceProvider;
import net.bluemind.core.rest.http.VertxServiceProvider;
import net.bluemind.network.topology.Topology;
import net.bluemind.server.api.Server;
import net.bluemind.server.api.TagDescriptor;
import net.bluemind.system.api.IInstallationAsync;
import net.bluemind.system.api.InstallationVersion;
import net.bluemind.webmodule.server.CSRFTokenManager;
import net.bluemind.webmodule.server.NeedVertx;
import net.bluemind.webmodule.server.handlers.AbstractIndexHandler;
import net.bluemind.webmodules.login.MessageResolverMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginHandler
extends AbstractIndexHandler
implements NeedVertx {
    private static final Logger logger = LoggerFactory.getLogger(LoginHandler.class);
    static Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
    private static final String DEFAULT_LANGUAGE = "en";
    private Vertx vertx;
    private HttpClientProvider clientProvider;
    private InstallationVersion version;

    static {
        cfg.setClassForTemplateLoading(LoginHandler.class, "/templates");
        cfg.setTagSyntax(0);
    }

    protected String getTemplateName() {
        return "login.xml";
    }

    protected void loadPageModel(HttpServerRequest httpServerRequest, Map<String, Object> map) {
        super.loadPageModel(httpServerRequest, map);
        String string = CSRFTokenManager.INSTANCE.initRequest(httpServerRequest);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("OSGI-INF/l10n/bundle", Locale.of(this.getLang(httpServerRequest)));
        if (httpServerRequest.path().endsWith("native")) {
            map.put("actionPath", "native");
        } else {
            map.put("actionPath", "index.html");
        }
        map.put("csrfToken", string);
        map.put("storedRequestId", "x");
        boolean bl = this.isPrivateComputer(httpServerRequest);
        map.put("priv", "" + bl);
        String string2 = httpServerRequest.params().get("userLogin");
        if (string2 == null) {
            string2 = "";
        }
        map.put("userLogin", string2);
        this.setAuthErrorCode(httpServerRequest, map, resourceBundle);
        String string3 = this.parseAskedUri(httpServerRequest);
        map.put("askedUri", string3);
        if (this.version != null) {
            map.put("bmVersion", this.version.versionName);
            map.put("buildVersion", this.version.softwareVersion);
            map.put("version-not-ok", !this.version.softwareVersion.equals(this.version.databaseVersion));
        } else {
            logger.warn("version is not available, use bundle version");
            map.put("bmVersion", BMVersion.getVersionName());
            map.put("buildVersion", BMVersion.getVersion());
        }
        map.put("msg", new MessageResolverMethod(resourceBundle, Locale.of(this.getLang(httpServerRequest))));
        logger.debug("display login page with model {}", map);
    }

    private boolean isPrivateComputer(HttpServerRequest httpServerRequest) {
        boolean bl = true;
        String string = httpServerRequest.headers().get(HttpHeaders.COOKIE);
        if (string != null) {
            for (Cookie cookie : ServerCookieDecoder.LAX.decode(string)) {
                if (!"BMPRIVACY".equalsIgnoreCase(cookie.name())) continue;
                bl = "true".equals(cookie.value());
                break;
            }
        }
        return bl;
    }

    private void setAuthErrorCode(HttpServerRequest httpServerRequest, Map<String, Object> map, ResourceBundle resourceBundle) {
        String string = httpServerRequest.params().get("authErrorCode");
        if (string != null && !string.isEmpty()) {
            if (string.equals("1") || string.equals("2")) {
                map.put("authErrorMsg", resourceBundle.getString("login.error.1"));
            } else {
                map.put("authErrorMsg", resourceBundle.getString("login.error.10"));
            }
        }
    }

    private String parseAskedUri(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.params().get("askedUri");
        if (string == null) {
            string = "/";
        } else {
            try {
                new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.warn("asked uri is not un uri : {} ", (Object)string, (Object)uRISyntaxException);
                string = "/";
            }
        }
        return string;
    }

    protected String getLang(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.headers().get("Accept-Language");
        if (string == null) {
            return DEFAULT_LANGUAGE;
        }
        return Locale.LanguageRange.parse(string).stream().map(languageRange -> Locale.forLanguageTag(languageRange.getRange())).findFirst().orElse(new Locale.Builder().setLanguage(DEFAULT_LANGUAGE).build()).getLanguage().toLowerCase();
    }

    private ITaggedServiceProvider getProvider() {
        ILocator iLocator = (string, asyncHandler) -> {
            String string2 = Topology.getIfAvailable().flatMap(iServiceTopology -> iServiceTopology.anyIfPresent(string).map(itemValue -> ((Server)itemValue.value).address())).orElse("127.0.0.1");
            asyncHandler.success((Object)new String[]{string2});
        };
        return new VertxServiceProvider(this.clientProvider, iLocator, Token.admin0());
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
        this.clientProvider = new HttpClientProvider(vertx);
        this.loadVersion();
    }

    private void loadVersion() {
        this.vertx.setTimer(2000L, l -> this.vertx.executeBlocking(() -> {
            ((IInstallationAsync)this.getProvider().instance(TagDescriptor.bm_core.getTag(), IInstallationAsync.class, new String[0])).getVersion((AsyncHandler)new AsyncHandler<InstallationVersion>(){

                public void success(InstallationVersion installationVersion) {
                    LoginHandler.this.version = installationVersion;
                }

                public void failure(Throwable throwable) {
                    logger.error("error retrieving installation version (message:{}), try again ", (Object)throwable.getMessage());
                    LoginHandler.this.loadVersion();
                }
            });
            return null;
        }));
    }
}

