/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.vcard.AbstractFactory;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.PropertyFactory;

public final class Uid
extends Property {
    private static final long serialVersionUID = -7120539613021006347L;
    private final URI uri;

    public Uid(URI uri) {
        super(Property.Id.UID);
        this.uri = uri;
    }

    public Uid(String uid) throws URISyntaxException, UnsupportedEncodingException {
        super(Property.Id.UID);
        this.uri = this.resolve(uid);
    }

    public Uid(List<Parameter> params, String value) throws URISyntaxException, UnsupportedEncodingException {
        super(Property.Id.UID, params);
        this.uri = this.resolve(value);
    }

    private URI resolve(String value) throws URISyntaxException, UnsupportedEncodingException {
        try {
            return new URI(URLEncoder.encode(value, "UTF8"));
        }
        catch (URISyntaxException e) {
            if (value.contains("\\,")) {
                String substringValue = value.substring(value.lastIndexOf("\\,") + 2);
                return new URI(URLEncoder.encode(substringValue, "UTF8"));
            }
            throw e;
        }
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public String getValue() {
        try {
            return URLDecoder.decode(this.uri.getPath(), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return this.uri.getPath();
        }
    }

    @Override
    public void validate() throws ValidationException {
        this.assertParametersEmpty();
    }

    public static class Factory
    extends AbstractFactory
    implements PropertyFactory<Uid> {
        public Factory() {
            super(Property.Id.UID.toString());
        }

        @Override
        public Uid createProperty(List<Parameter> params, String value) throws URISyntaxException, UnsupportedEncodingException {
            return new Uid(params, value);
        }

        @Override
        public Uid createProperty(Group group, List<Parameter> params, String value) throws UnsupportedEncodingException {
            return null;
        }
    }
}

