/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.text.MessageFormat;
import java.util.List;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.vcard.AbstractFactory;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.PropertyFactory;

public final class Mailer
extends Property {
    private static final long serialVersionUID = 6134254373259957228L;
    private final String value;

    public Mailer(String value) {
        this((Group)null, value);
    }

    public Mailer(Group group, String value) {
        super(group, Property.Id.MAILER);
        this.value = value;
    }

    public Mailer(List<Parameter> params, String value) {
        this(null, params, value);
    }

    public Mailer(Group group, List<Parameter> params, String value) {
        super(group, Property.Id.MAILER, params);
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void validate() throws ValidationException {
        for (Parameter param : this.getParameters()) {
            Parameter.Id id = param.getId();
            if (Parameter.Id.EXTENDED.equals((Object)id)) continue;
            throw new ValidationException(MessageFormat.format("Illegal parameter [{0}]", new Object[]{id}));
        }
    }

    public static class Factory
    extends AbstractFactory
    implements PropertyFactory<Mailer> {
        public Factory() {
            super(Property.Id.MAILER.toString());
        }

        @Override
        public Mailer createProperty(List<Parameter> params, String value) {
            return new Mailer(params, value);
        }

        @Override
        public Mailer createProperty(Group group, List<Parameter> params, String value) {
            return new Mailer(group, params, value);
        }
    }
}

