/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.property.Kind;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class VCard
implements Serializable {
    private static final long serialVersionUID = -4784034340843199392L;
    private final List<Property> properties;

    public VCard() {
        this(new ArrayList<Property>());
    }

    public VCard(List<Property> properties) {
        this.properties = new CopyOnWriteArrayList<Property>(properties);
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<Property> getProperties(Property.Id id) {
        ArrayList<Property> matches = new ArrayList<Property>();
        for (Property p : this.properties) {
            if (!p.getId().equals((Object)id)) continue;
            matches.add(p);
        }
        return Collections.unmodifiableList(matches);
    }

    public <T extends Property> T getProperty(Property.Id id) {
        for (Property p : this.properties) {
            if (!p.getId().equals((Object)id)) continue;
            return (T)p;
        }
        return null;
    }

    public List<Property> getExtendedProperties(String name) {
        ArrayList<Property> matches = new ArrayList<Property>();
        for (Property p : this.properties) {
            if (!p.getId().equals((Object)Property.Id.EXTENDED) || !p.extendedName.equals(name)) continue;
            matches.add(p);
        }
        return Collections.unmodifiableList(matches);
    }

    public Property getExtendedProperty(String name) {
        for (Property p : this.properties) {
            if (!p.getId().equals((Object)Property.Id.EXTENDED) || !p.extendedName.equals(name)) continue;
            return p;
        }
        return null;
    }

    public void validate() throws ValidationException {
        this.assertOne(Property.Id.VERSION);
        this.assertOne(Property.Id.FN);
        boolean isKindGroup = false;
        List<Property> properties = this.getProperties(Property.Id.KIND);
        if (properties.size() > 1) {
            throw new ValidationException("Property [" + (Object)((Object)Property.Id.KIND) + "] must be specified zero or once");
        }
        if (properties.size() == 1) {
            isKindGroup = properties.iterator().next().getValue().equals(Kind.GROUP.getValue());
        }
        for (Property property : this.getProperties()) {
            if (!isKindGroup && property.getId().equals((Object)Property.Id.MEMBER)) {
                throw new ValidationException("Property [" + (Object)((Object)Property.Id.MEMBER) + "] can only be specified if the KIND property value is \"group\".");
            }
            property.validate();
        }
    }

    private void assertOne(Property.Id propertyId) throws ValidationException {
        List<Property> properties = this.getProperties(propertyId);
        if (properties.size() != 1) {
            throw new ValidationException("Property [" + (Object)((Object)propertyId) + "] must be specified once");
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BEGIN:VCARD");
        b.append("\r\n");
        for (Property prop : this.properties) {
            b.append(prop);
        }
        b.append("END:VCARD");
        b.append("\r\n");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof VCard) {
            VCard card = (VCard)obj;
            return new EqualsBuilder().append(this.getProperties(), card.getProperties()).isEquals();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getProperties()).toHashCode();
    }
}

