/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.http;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class HttpClientRequestResendCount {
    private static final ContextKey<HttpClientRequestResendCount> KEY = ContextKey.named("opentelemetry-http-client-resend-key");
    private static final AtomicIntegerFieldUpdater<HttpClientRequestResendCount> resendsUpdater = AtomicIntegerFieldUpdater.newUpdater(HttpClientRequestResendCount.class, "resends");
    private volatile int resends = 0;

    public static Context initialize(Context context) {
        if (context.get(KEY) != null) {
            return context;
        }
        return context.with(KEY, new HttpClientRequestResendCount());
    }

    public static int get(Context context) {
        HttpClientRequestResendCount resend = context.get(KEY);
        return resend == null ? 0 : resend.resends;
    }

    static int getAndIncrement(Context context) {
        HttpClientRequestResendCount resend = context.get(KEY);
        if (resend == null) {
            return 0;
        }
        return resendsUpdater.getAndIncrement(resend);
    }

    private HttpClientRequestResendCount() {
    }
}

