/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2022
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.serviceprovider.rest;

import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.rest.http.ClientSideServiceProvider;
import net.bluemind.network.topology.Topology;
import net.bluemind.serviceprovider.IServiceProviderResolver;

public class RestClientResolver implements IServiceProviderResolver {

	private final String coreUrl;

	public RestClientResolver() {
		String host = Topology.getIfAvailable().map(topo -> topo.core().value.address()).orElse("127.0.0.1");
		this.coreUrl = "http://" + host + ":8090";
	}

	@Override
	public IServiceProvider resolve(String authKey) {
		return ClientSideServiceProvider.getProvider(coreUrl, authKey);
	}

}
