/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.group.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class GroupGwtSerDer implements GwtSerDer<net.bluemind.group.api.Group> {

	private net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer parent = new  net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer();
	public GroupGwtSerDer( ) {
	}

	@Override
	public net.bluemind.group.api.Group deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.group.api.Group ret = new net.bluemind.group.api.Group();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.group.api.Group ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue propertiesJSON = json.get("properties");
		ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		JSONValue hiddenMembersJSON = json.get("hiddenMembers");
		ret.hiddenMembers =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenMembersJSON);
		JSONValue mailArchivedJSON = json.get("mailArchived");
		ret.mailArchived =  GwtSerDerUtils.BOOLEAN.deserialize(mailArchivedJSON);
		JSONValue memberCountJSON = json.get("memberCount");
		ret.memberCount =  GwtSerDerUtils.INT.deserialize(memberCountJSON);
	}

	public void deserializeTo(net.bluemind.group.api.Group ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("description")) {
			JSONValue descriptionJSON = json.get("description");
			ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			JSONValue propertiesJSON = json.get("properties");
			ret.properties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(propertiesJSON);
		}
		if (!childPropertiesToIgnore.contains("hiddenMembers")) {
			JSONValue hiddenMembersJSON = json.get("hiddenMembers");
			ret.hiddenMembers =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenMembersJSON);
		}
		if (!childPropertiesToIgnore.contains("mailArchived")) {
			JSONValue mailArchivedJSON = json.get("mailArchived");
			ret.mailArchived =  GwtSerDerUtils.BOOLEAN.deserialize(mailArchivedJSON);
		}
		if (!childPropertiesToIgnore.contains("memberCount")) {
			JSONValue memberCountJSON = json.get("memberCount");
			ret.memberCount =  GwtSerDerUtils.INT.deserialize(memberCountJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.group.api.Group o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.group.api.Group o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		ret.put("hiddenMembers",  GwtSerDerUtils.BOOLEAN.serialize( o.hiddenMembers ));
		ret.put("mailArchived",  GwtSerDerUtils.BOOLEAN.serialize( o.mailArchived ));
		ret.put("memberCount",  GwtSerDerUtils.INT.serialize( o.memberCount ));
	}

	public void serializeTo(net.bluemind.group.api.Group o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("description")) {
			ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		}
		if (!childPropertiesToIgnore.contains("properties")) {
			ret.put("properties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.properties ));
		}
		if (!childPropertiesToIgnore.contains("hiddenMembers")) {
			ret.put("hiddenMembers",  GwtSerDerUtils.BOOLEAN.serialize( o.hiddenMembers ));
		}
		if (!childPropertiesToIgnore.contains("mailArchived")) {
			ret.put("mailArchived",  GwtSerDerUtils.BOOLEAN.serialize( o.mailArchived ));
		}
		if (!childPropertiesToIgnore.contains("memberCount")) {
			ret.put("memberCount",  GwtSerDerUtils.INT.serialize( o.memberCount ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}