/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.icalendar.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ICalendarElementVAlarmGwtSerDer implements GwtSerDer<net.bluemind.icalendar.api.ICalendarElement.VAlarm> {

	public ICalendarElementVAlarmGwtSerDer( ) {
	}

	@Override
	public net.bluemind.icalendar.api.ICalendarElement.VAlarm deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.icalendar.api.ICalendarElement.VAlarm ret = new net.bluemind.icalendar.api.ICalendarElement.VAlarm();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement.VAlarm ret, JSONObject json) {
		JSONValue actionJSON = json.get("action");
		ret.action =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementVAlarmActionGwtSerDer().deserialize(actionJSON);
		JSONValue triggerJSON = json.get("trigger");
		ret.trigger =  GwtSerDerUtils.INT.deserialize(triggerJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue durationJSON = json.get("duration");
		ret.duration =  GwtSerDerUtils.INT.deserialize(durationJSON);
		JSONValue repeatJSON = json.get("repeat");
		ret.repeat =  GwtSerDerUtils.INT.deserialize(repeatJSON);
		JSONValue summaryJSON = json.get("summary");
		ret.summary =  GwtSerDerUtils.STRING.deserialize(summaryJSON);
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement.VAlarm ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("action")) {
			JSONValue actionJSON = json.get("action");
			ret.action =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementVAlarmActionGwtSerDer().deserialize(actionJSON);
		}
		if (!childPropertiesToIgnore.contains("trigger")) {
			JSONValue triggerJSON = json.get("trigger");
			ret.trigger =  GwtSerDerUtils.INT.deserialize(triggerJSON);
		}
		if (!childPropertiesToIgnore.contains("description")) {
			JSONValue descriptionJSON = json.get("description");
			ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		}
		if (!childPropertiesToIgnore.contains("duration")) {
			JSONValue durationJSON = json.get("duration");
			ret.duration =  GwtSerDerUtils.INT.deserialize(durationJSON);
		}
		if (!childPropertiesToIgnore.contains("repeat")) {
			JSONValue repeatJSON = json.get("repeat");
			ret.repeat =  GwtSerDerUtils.INT.deserialize(repeatJSON);
		}
		if (!childPropertiesToIgnore.contains("summary")) {
			JSONValue summaryJSON = json.get("summary");
			ret.summary =  GwtSerDerUtils.STRING.deserialize(summaryJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.icalendar.api.ICalendarElement.VAlarm o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement.VAlarm o, JSONObject ret) {

		ret.put("action",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementVAlarmActionGwtSerDer().serialize( o.action ));
		ret.put("trigger",  GwtSerDerUtils.INT.serialize( o.trigger ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("duration",  GwtSerDerUtils.INT.serialize( o.duration ));
		ret.put("repeat",  GwtSerDerUtils.INT.serialize( o.repeat ));
		ret.put("summary",  GwtSerDerUtils.STRING.serialize( o.summary ));
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement.VAlarm o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("action")) {
			ret.put("action",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementVAlarmActionGwtSerDer().serialize( o.action ));
		}
		if (!childPropertiesToIgnore.contains("trigger")) {
			ret.put("trigger",  GwtSerDerUtils.INT.serialize( o.trigger ));
		}
		if (!childPropertiesToIgnore.contains("description")) {
			ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		}
		if (!childPropertiesToIgnore.contains("duration")) {
			ret.put("duration",  GwtSerDerUtils.INT.serialize( o.duration ));
		}
		if (!childPropertiesToIgnore.contains("repeat")) {
			ret.put("repeat",  GwtSerDerUtils.INT.serialize( o.repeat ));
		}
		if (!childPropertiesToIgnore.contains("summary")) {
			ret.put("summary",  GwtSerDerUtils.STRING.serialize( o.summary ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}