/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElementRRuleFrequency extends JavaScriptObject {

	protected JsICalendarElementRRuleFrequency() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsICalendarElementRRuleFrequency SECONDLY()
	/*-{
		return "SECONDLY";
	}-*/;

	public static final native JsICalendarElementRRuleFrequency MINUTELY()
	/*-{
		return "MINUTELY";
	}-*/;

	public static final native JsICalendarElementRRuleFrequency HOURLY()
	/*-{
		return "HOURLY";
	}-*/;

	public static final native JsICalendarElementRRuleFrequency DAILY()
	/*-{
		return "DAILY";
	}-*/;

	public static final native JsICalendarElementRRuleFrequency WEEKLY()
	/*-{
		return "WEEKLY";
	}-*/;

	public static final native JsICalendarElementRRuleFrequency MONTHLY()
	/*-{
		return "MONTHLY";
	}-*/;

	public static final native JsICalendarElementRRuleFrequency YEARLY()
	/*-{
		return "YEARLY";
	}-*/;

	public static final JsICalendarElementRRuleFrequency create(net.bluemind.icalendar.api.ICalendarElement.RRule.Frequency value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case SECONDLY:
				return SECONDLY();
			case MINUTELY:
				return MINUTELY();
			case HOURLY:
				return HOURLY();
			case DAILY:
				return DAILY();
			case WEEKLY:
				return WEEKLY();
			case MONTHLY:
				return MONTHLY();
			case YEARLY:
				return YEARLY();
			default:
				return null;
			}
		}
	}
}