/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class OrgUnitsEndpointPromise implements net.bluemind.directory.api.IOrgUnitsPromise {

	private net.bluemind.directory.api.IOrgUnitsAsync impl;

	public OrgUnitsEndpointPromise(net.bluemind.directory.api.IOrgUnitsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.directory.api.OrgUnit value  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, value,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getAdministratorRoles(String uid ,  String dirUid ,  List<String> groups  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAdministratorRoles(uid, dirUid, groups,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getAdministrators(String uid ,  boolean hierarchical  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAdministrators(uid, hierarchical,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>> getChildren(String uid  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getChildren(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.directory.api.OrgUnit> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.directory.api.OrgUnitPath> getPath(String uid  ) {
		
		CompletableFuture<net.bluemind.directory.api.OrgUnitPath> ret = new CompletableFuture<net.bluemind.directory.api.OrgUnitPath>();
		AsyncHandler<net.bluemind.directory.api.OrgUnitPath> handler = new AsyncHandler<net.bluemind.directory.api.OrgUnitPath>() {
			public void success(net.bluemind.directory.api.OrgUnitPath value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getPath(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.directory.api.OrgUnitPath>> listByAdministrator(String administrator ,  List<String> groups  ) {
		
		CompletableFuture<List<net.bluemind.directory.api.OrgUnitPath>> ret = new CompletableFuture<List<net.bluemind.directory.api.OrgUnitPath>>();
		AsyncHandler<List<net.bluemind.directory.api.OrgUnitPath>> handler = new AsyncHandler<List<net.bluemind.directory.api.OrgUnitPath>>() {
			public void success(List<net.bluemind.directory.api.OrgUnitPath> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listByAdministrator(administrator, groups,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> removeAdministrator(String administrator  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.removeAdministrator(administrator,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.directory.api.OrgUnitPath>> search(net.bluemind.directory.api.OrgUnitQuery query  ) {
		
		CompletableFuture<List<net.bluemind.directory.api.OrgUnitPath>> ret = new CompletableFuture<List<net.bluemind.directory.api.OrgUnitPath>>();
		AsyncHandler<List<net.bluemind.directory.api.OrgUnitPath>> handler = new AsyncHandler<List<net.bluemind.directory.api.OrgUnitPath>>() {
			public void success(List<net.bluemind.directory.api.OrgUnitPath> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.search(query,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setAdministratorRoles(String uid ,  String dirUid ,  Set<String> roles  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setAdministratorRoles(uid, dirUid, roles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.directory.api.OrgUnit value  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, value,  handler);
		return ret;
	}

}
