/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailmessage.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailTipContextGwtSerDer implements GwtSerDer<net.bluemind.mailmessage.api.MailTipContext> {

	public MailTipContextGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailmessage.api.MailTipContext deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailmessage.api.MailTipContext ret = new net.bluemind.mailmessage.api.MailTipContext();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailmessage.api.MailTipContext ret, JSONObject json) {
		JSONValue messageContextJSON = json.get("messageContext");
		ret.messageContext =  new net.bluemind.mailmessage.api.gwt.serder.MessageContextGwtSerDer().deserialize(messageContextJSON);
		JSONValue filterJSON = json.get("filter");
		ret.filter =  new net.bluemind.mailmessage.api.gwt.serder.MailTipFilterGwtSerDer().deserialize(filterJSON);
	}

	public void deserializeTo(net.bluemind.mailmessage.api.MailTipContext ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("messageContext")) {
			JSONValue messageContextJSON = json.get("messageContext");
			ret.messageContext =  new net.bluemind.mailmessage.api.gwt.serder.MessageContextGwtSerDer().deserialize(messageContextJSON);
		}
		if (!childPropertiesToIgnore.contains("filter")) {
			JSONValue filterJSON = json.get("filter");
			ret.filter =  new net.bluemind.mailmessage.api.gwt.serder.MailTipFilterGwtSerDer().deserialize(filterJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailmessage.api.MailTipContext o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailmessage.api.MailTipContext o, JSONObject ret) {

		ret.put("messageContext",  new net.bluemind.mailmessage.api.gwt.serder.MessageContextGwtSerDer().serialize( o.messageContext ));
		ret.put("filter",  new net.bluemind.mailmessage.api.gwt.serder.MailTipFilterGwtSerDer().serialize( o.filter ));
	}

	public void serializeTo(net.bluemind.mailmessage.api.MailTipContext o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("messageContext")) {
			ret.put("messageContext",  new net.bluemind.mailmessage.api.gwt.serder.MessageContextGwtSerDer().serialize( o.messageContext ));
		}
		if (!childPropertiesToIgnore.contains("filter")) {
			ret.put("filter",  new net.bluemind.mailmessage.api.gwt.serder.MailTipFilterGwtSerDer().serialize( o.filter ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}