/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailmessage.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class MailTipSockJsEndpoint implements net.bluemind.mailmessage.api.IMailTipAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public MailTipSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mailtip/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public MailTipSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void getMailTips(net.bluemind.mailmessage.api.MailTipContext mailtipContext, final AsyncHandler<List<net.bluemind.mailmessage.api.MailTips>> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.mailmessage.api.gwt.serder.MailTipContextGwtSerDer().serialize( mailtipContext);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<net.bluemind.mailmessage.api.MailTips>>(handler) {
					@Override
			protected List<net.bluemind.mailmessage.api.MailTips> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailmessage.api.gwt.serder.MailTipsGwtSerDer()).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.mailmessage.api.IMailTipPromise promiseApi() {
		return new MailTipEndpointPromise(this);
	}

}
