/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterVacationGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.MailFilter.Vacation> {

	public MailFilterVacationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.MailFilter.Vacation deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.MailFilter.Vacation ret = new net.bluemind.mailbox.api.MailFilter.Vacation();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailFilter.Vacation ret, JSONObject json) {
		JSONValue enabledJSON = json.get("enabled");
		ret.enabled =  GwtSerDerUtils.BOOLEAN.deserialize(enabledJSON);
		JSONValue startJSON = json.get("start");
		ret.start =  GwtSerDerUtils.DATE.deserialize(startJSON);
		JSONValue endJSON = json.get("end");
		ret.end =  GwtSerDerUtils.DATE.deserialize(endJSON);
		JSONValue textJSON = json.get("text");
		ret.text =  GwtSerDerUtils.STRING.deserialize(textJSON);
		JSONValue textHtmlJSON = json.get("textHtml");
		ret.textHtml =  GwtSerDerUtils.STRING.deserialize(textHtmlJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.MailFilter.Vacation ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("enabled")) {
			JSONValue enabledJSON = json.get("enabled");
			ret.enabled =  GwtSerDerUtils.BOOLEAN.deserialize(enabledJSON);
		}
		if (!childPropertiesToIgnore.contains("start")) {
			JSONValue startJSON = json.get("start");
			ret.start =  GwtSerDerUtils.DATE.deserialize(startJSON);
		}
		if (!childPropertiesToIgnore.contains("end")) {
			JSONValue endJSON = json.get("end");
			ret.end =  GwtSerDerUtils.DATE.deserialize(endJSON);
		}
		if (!childPropertiesToIgnore.contains("text")) {
			JSONValue textJSON = json.get("text");
			ret.text =  GwtSerDerUtils.STRING.deserialize(textJSON);
		}
		if (!childPropertiesToIgnore.contains("textHtml")) {
			JSONValue textHtmlJSON = json.get("textHtml");
			ret.textHtml =  GwtSerDerUtils.STRING.deserialize(textHtmlJSON);
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			JSONValue subjectJSON = json.get("subject");
			ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.MailFilter.Vacation o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.MailFilter.Vacation o, JSONObject ret) {

		ret.put("enabled",  GwtSerDerUtils.BOOLEAN.serialize( o.enabled ));
		ret.put("start",  GwtSerDerUtils.DATE.serialize( o.start ));
		ret.put("end",  GwtSerDerUtils.DATE.serialize( o.end ));
		ret.put("text",  GwtSerDerUtils.STRING.serialize( o.text ));
		ret.put("textHtml",  GwtSerDerUtils.STRING.serialize( o.textHtml ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
	}

	public void serializeTo(net.bluemind.mailbox.api.MailFilter.Vacation o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("enabled")) {
			ret.put("enabled",  GwtSerDerUtils.BOOLEAN.serialize( o.enabled ));
		}
		if (!childPropertiesToIgnore.contains("start")) {
			ret.put("start",  GwtSerDerUtils.DATE.serialize( o.start ));
		}
		if (!childPropertiesToIgnore.contains("end")) {
			ret.put("end",  GwtSerDerUtils.DATE.serialize( o.end ));
		}
		if (!childPropertiesToIgnore.contains("text")) {
			ret.put("text",  GwtSerDerUtils.STRING.serialize( o.text ));
		}
		if (!childPropertiesToIgnore.contains("textHtml")) {
			ret.put("textHtml",  GwtSerDerUtils.STRING.serialize( o.textHtml ));
		}
		if (!childPropertiesToIgnore.contains("subject")) {
			ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}