/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class UserSettingsEndpointPromise implements net.bluemind.user.api.IUserSettingsPromise {

	private net.bluemind.user.api.IUserSettingsAsync impl;

	public UserSettingsEndpointPromise(net.bluemind.user.api.IUserSettingsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Map<String,String>> get(String uid  ) {
		
		CompletableFuture<Map<String,String>> ret = new CompletableFuture<Map<String,String>>();
		AsyncHandler<Map<String,String>> handler = new AsyncHandler<Map<String,String>>() {
			public void success(Map<String,String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.get(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<String> getOne(String uid ,  String name  ) {
		
		CompletableFuture<String> ret = new CompletableFuture<String>();
		AsyncHandler<String> handler = new AsyncHandler<String>() {
			public void success(String value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getOne(uid, name,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> set(String uid ,  Map<String,String> settings  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.set(uid, settings,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setOne(String uid ,  String name ,  String value  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setOne(uid, name, value,  handler);
		return ret;
	}

}
