/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.attachment.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class AttachmentGwtEndpoint implements net.bluemind.attachment.api.IAttachmentAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public AttachmentGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/attachment/{domainUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public AttachmentGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void getConfiguration(final AsyncHandler<net.bluemind.attachment.api.Configuration> handler) {
		String postUri = "/_config";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.attachment.api.Configuration>(handler) {
			@Override
			protected net.bluemind.attachment.api.Configuration handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.attachment.api.gwt.serder.ConfigurationGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void share(String name, Stream document, final AsyncHandler<net.bluemind.attachment.api.AttachedFile> handler) {
		String postUri = "/{name}/share";

		postUri = postUri.replace("{name}", URL.encodePathSegment(""+name));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( document);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.attachment.api.AttachedFile>(handler) {
			@Override
			protected net.bluemind.attachment.api.AttachedFile handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.attachment.api.gwt.serder.AttachedFileGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void shareDedup(String extension, Stream document, final AsyncHandler<net.bluemind.attachment.api.AttachedFile> handler) {
		String postUri = "/{extension}/share_dedup";

		postUri = postUri.replace("{extension}", URL.encodePathSegment(""+extension));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.STREAM.serialize( document);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.attachment.api.AttachedFile>(handler) {
			@Override
			protected net.bluemind.attachment.api.AttachedFile handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.attachment.api.gwt.serder.AttachedFileGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void unShare(String url, final AsyncHandler<Void> handler) {
		String postUri = "/{url}/unshare";

		postUri = postUri.replace("{url}", URL.encodePathSegment(""+url));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.attachment.api.IAttachmentPromise promiseApi() {
		return new AttachmentEndpointPromise(this);
	}
}
