/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SortDescriptorFieldGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.SortDescriptor.Field> {

	public SortDescriptorFieldGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.SortDescriptor.Field deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.SortDescriptor.Field ret = new net.bluemind.core.container.model.SortDescriptor.Field();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.SortDescriptor.Field ret, JSONObject json) {
		JSONValue columnJSON = json.get("column");
		ret.column =  GwtSerDerUtils.STRING.deserialize(columnJSON);
		JSONValue dirJSON = json.get("dir");
		ret.dir =  new net.bluemind.core.container.model.gwt.serder.SortDescriptorDirectionGwtSerDer().deserialize(dirJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.SortDescriptor.Field ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("column")) {
			JSONValue columnJSON = json.get("column");
			ret.column =  GwtSerDerUtils.STRING.deserialize(columnJSON);
		}
		if (!childPropertiesToIgnore.contains("dir")) {
			JSONValue dirJSON = json.get("dir");
			ret.dir =  new net.bluemind.core.container.model.gwt.serder.SortDescriptorDirectionGwtSerDer().deserialize(dirJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.SortDescriptor.Field o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.SortDescriptor.Field o, JSONObject ret) {

		ret.put("column",  GwtSerDerUtils.STRING.serialize( o.column ));
		ret.put("dir",  new net.bluemind.core.container.model.gwt.serder.SortDescriptorDirectionGwtSerDer().serialize( o.dir ));
	}

	public void serializeTo(net.bluemind.core.container.model.SortDescriptor.Field o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("column")) {
			ret.put("column",  GwtSerDerUtils.STRING.serialize( o.column ));
		}
		if (!childPropertiesToIgnore.contains("dir")) {
			ret.put("dir",  new net.bluemind.core.container.model.gwt.serder.SortDescriptorDirectionGwtSerDer().serialize( o.dir ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}