/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ItemIdentifierGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ItemIdentifier> {

	private net.bluemind.core.container.model.gwt.serder.ItemVersionGwtSerDer parent = new  net.bluemind.core.container.model.gwt.serder.ItemVersionGwtSerDer();
	public ItemIdentifierGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ItemIdentifier deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ItemIdentifier ret = new net.bluemind.core.container.model.ItemIdentifier();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ItemIdentifier ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.ItemIdentifier ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ItemIdentifier o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ItemIdentifier o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
	}

	public void serializeTo(net.bluemind.core.container.model.ItemIdentifier o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}