/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class IdQueryGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.IdQuery> {

	public IdQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.IdQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.IdQuery ret = new net.bluemind.core.container.model.IdQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.IdQuery ret, JSONObject json) {
		JSONValue filterJSON = json.get("filter");
		ret.filter =  new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().deserialize(filterJSON);
		JSONValue limitJSON = json.get("limit");
		ret.limit =  GwtSerDerUtils.INT.deserialize(limitJSON);
		JSONValue offsetJSON = json.get("offset");
		ret.offset =  GwtSerDerUtils.INT.deserialize(offsetJSON);
		JSONValue knownContainerVersionJSON = json.get("knownContainerVersion");
		ret.knownContainerVersion =  GwtSerDerUtils.LONG.deserialize(knownContainerVersionJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.IdQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("filter")) {
			JSONValue filterJSON = json.get("filter");
			ret.filter =  new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().deserialize(filterJSON);
		}
		if (!childPropertiesToIgnore.contains("limit")) {
			JSONValue limitJSON = json.get("limit");
			ret.limit =  GwtSerDerUtils.INT.deserialize(limitJSON);
		}
		if (!childPropertiesToIgnore.contains("offset")) {
			JSONValue offsetJSON = json.get("offset");
			ret.offset =  GwtSerDerUtils.INT.deserialize(offsetJSON);
		}
		if (!childPropertiesToIgnore.contains("knownContainerVersion")) {
			JSONValue knownContainerVersionJSON = json.get("knownContainerVersion");
			ret.knownContainerVersion =  GwtSerDerUtils.LONG.deserialize(knownContainerVersionJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.IdQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.IdQuery o, JSONObject ret) {

		ret.put("filter",  new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( o.filter ));
		ret.put("limit",  GwtSerDerUtils.INT.serialize( o.limit ));
		ret.put("offset",  GwtSerDerUtils.INT.serialize( o.offset ));
		ret.put("knownContainerVersion",  GwtSerDerUtils.LONG.serialize( o.knownContainerVersion ));
	}

	public void serializeTo(net.bluemind.core.container.model.IdQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("filter")) {
			ret.put("filter",  new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( o.filter ));
		}
		if (!childPropertiesToIgnore.contains("limit")) {
			ret.put("limit",  GwtSerDerUtils.INT.serialize( o.limit ));
		}
		if (!childPropertiesToIgnore.contains("offset")) {
			ret.put("offset",  GwtSerDerUtils.INT.serialize( o.offset ));
		}
		if (!childPropertiesToIgnore.contains("knownContainerVersion")) {
			ret.put("knownContainerVersion",  GwtSerDerUtils.LONG.serialize( o.knownContainerVersion ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}