/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerSyncResultGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ContainerSyncResult> {

	public ContainerSyncResultGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ContainerSyncResult deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerSyncResult ret = new net.bluemind.core.container.model.ContainerSyncResult();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerSyncResult ret, JSONObject json) {
		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.core.container.model.gwt.serder.ContainerSyncStatusGwtSerDer().deserialize(statusJSON);
		JSONValue addedJSON = json.get("added");
		ret.added =  GwtSerDerUtils.INT.deserialize(addedJSON);
		JSONValue updatedJSON = json.get("updated");
		ret.updated =  GwtSerDerUtils.INT.deserialize(updatedJSON);
		JSONValue removedJSON = json.get("removed");
		ret.removed =  GwtSerDerUtils.INT.deserialize(removedJSON);
		JSONValue unhandledJSON = json.get("unhandled");
		ret.unhandled =  GwtSerDerUtils.INT.deserialize(unhandledJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerSyncResult ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("status")) {
			JSONValue statusJSON = json.get("status");
			ret.status =  new net.bluemind.core.container.model.gwt.serder.ContainerSyncStatusGwtSerDer().deserialize(statusJSON);
		}
		if (!childPropertiesToIgnore.contains("added")) {
			JSONValue addedJSON = json.get("added");
			ret.added =  GwtSerDerUtils.INT.deserialize(addedJSON);
		}
		if (!childPropertiesToIgnore.contains("updated")) {
			JSONValue updatedJSON = json.get("updated");
			ret.updated =  GwtSerDerUtils.INT.deserialize(updatedJSON);
		}
		if (!childPropertiesToIgnore.contains("removed")) {
			JSONValue removedJSON = json.get("removed");
			ret.removed =  GwtSerDerUtils.INT.deserialize(removedJSON);
		}
		if (!childPropertiesToIgnore.contains("unhandled")) {
			JSONValue unhandledJSON = json.get("unhandled");
			ret.unhandled =  GwtSerDerUtils.INT.deserialize(unhandledJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerSyncResult o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerSyncResult o, JSONObject ret) {

		ret.put("status",  new net.bluemind.core.container.model.gwt.serder.ContainerSyncStatusGwtSerDer().serialize( o.status ));
		ret.put("added",  GwtSerDerUtils.INT.serialize( o.added ));
		ret.put("updated",  GwtSerDerUtils.INT.serialize( o.updated ));
		ret.put("removed",  GwtSerDerUtils.INT.serialize( o.removed ));
		ret.put("unhandled",  GwtSerDerUtils.INT.serialize( o.unhandled ));
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerSyncResult o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("status")) {
			ret.put("status",  new net.bluemind.core.container.model.gwt.serder.ContainerSyncStatusGwtSerDer().serialize( o.status ));
		}
		if (!childPropertiesToIgnore.contains("added")) {
			ret.put("added",  GwtSerDerUtils.INT.serialize( o.added ));
		}
		if (!childPropertiesToIgnore.contains("updated")) {
			ret.put("updated",  GwtSerDerUtils.INT.serialize( o.updated ));
		}
		if (!childPropertiesToIgnore.contains("removed")) {
			ret.put("removed",  GwtSerDerUtils.INT.serialize( o.removed ));
		}
		if (!childPropertiesToIgnore.contains("unhandled")) {
			ret.put("unhandled",  GwtSerDerUtils.INT.serialize( o.unhandled ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}