/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerDescriptorGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ContainerDescriptor> {

	private net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer parent = new  net.bluemind.core.container.model.gwt.serder.BaseContainerDescriptorGwtSerDer();
	public ContainerDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ContainerDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ContainerDescriptor ret = new net.bluemind.core.container.model.ContainerDescriptor();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerDescriptor ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue writableJSON = json.get("writable");
		ret.writable =  GwtSerDerUtils.BOOLEAN.deserialize(writableJSON);
		JSONValue verbsJSON = json.get("verbs");
		ret.verbs =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).deserialize(verbsJSON);
		JSONValue offlineSyncJSON = json.get("offlineSync");
		ret.offlineSync =  GwtSerDerUtils.BOOLEAN.deserialize(offlineSyncJSON);
		JSONValue automountJSON = json.get("automount");
		ret.automount =  GwtSerDerUtils.BOOLEAN.deserialize(automountJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.ContainerDescriptor ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("writable")) {
			JSONValue writableJSON = json.get("writable");
			ret.writable =  GwtSerDerUtils.BOOLEAN.deserialize(writableJSON);
		}
		if (!childPropertiesToIgnore.contains("verbs")) {
			JSONValue verbsJSON = json.get("verbs");
			ret.verbs =  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).deserialize(verbsJSON);
		}
		if (!childPropertiesToIgnore.contains("offlineSync")) {
			JSONValue offlineSyncJSON = json.get("offlineSync");
			ret.offlineSync =  GwtSerDerUtils.BOOLEAN.deserialize(offlineSyncJSON);
		}
		if (!childPropertiesToIgnore.contains("automount")) {
			JSONValue automountJSON = json.get("automount");
			ret.automount =  GwtSerDerUtils.BOOLEAN.deserialize(automountJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ContainerDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerDescriptor o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("writable",  GwtSerDerUtils.BOOLEAN.serialize( o.writable ));
		ret.put("verbs",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).serialize( o.verbs ));
		ret.put("offlineSync",  GwtSerDerUtils.BOOLEAN.serialize( o.offlineSync ));
		ret.put("automount",  GwtSerDerUtils.BOOLEAN.serialize( o.automount ));
	}

	public void serializeTo(net.bluemind.core.container.model.ContainerDescriptor o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("writable")) {
			ret.put("writable",  GwtSerDerUtils.BOOLEAN.serialize( o.writable ));
		}
		if (!childPropertiesToIgnore.contains("verbs")) {
			ret.put("verbs",  new GwtSerDerUtils.SetSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).serialize( o.verbs ));
		}
		if (!childPropertiesToIgnore.contains("offlineSync")) {
			ret.put("offlineSync",  GwtSerDerUtils.BOOLEAN.serialize( o.offlineSync ));
		}
		if (!childPropertiesToIgnore.contains("automount")) {
			ret.put("automount",  GwtSerDerUtils.BOOLEAN.serialize( o.automount ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}