/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ChangeLogEntryGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ChangeLogEntry> {

	public ChangeLogEntryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ChangeLogEntry deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ChangeLogEntry ret = new net.bluemind.core.container.model.ChangeLogEntry();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ChangeLogEntry ret, JSONObject json) {
		JSONValue versionJSON = json.get("version");
		ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
		JSONValue itemUidJSON = json.get("itemUid");
		ret.itemUid =  GwtSerDerUtils.STRING.deserialize(itemUidJSON);
		JSONValue itemExtIdJSON = json.get("itemExtId");
		ret.itemExtId =  GwtSerDerUtils.STRING.deserialize(itemExtIdJSON);
		JSONValue authorJSON = json.get("author");
		ret.author =  GwtSerDerUtils.STRING.deserialize(authorJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.core.container.model.gwt.serder.ChangeLogEntryTypeGwtSerDer().deserialize(typeJSON);
		JSONValue dateJSON = json.get("date");
		ret.date =  GwtSerDerUtils.DATE.deserialize(dateJSON);
		JSONValue originJSON = json.get("origin");
		ret.origin =  GwtSerDerUtils.STRING.deserialize(originJSON);
		JSONValue internalIdJSON = json.get("internalId");
		ret.internalId =  GwtSerDerUtils.LONG.deserialize(internalIdJSON);
		JSONValue weightSeedJSON = json.get("weightSeed");
		ret.weightSeed =  GwtSerDerUtils.LONG.deserialize(weightSeedJSON);
	}

	public void deserializeTo(net.bluemind.core.container.model.ChangeLogEntry ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("version")) {
			JSONValue versionJSON = json.get("version");
			ret.version =  GwtSerDerUtils.LONG.deserialize(versionJSON);
		}
		if (!childPropertiesToIgnore.contains("itemUid")) {
			JSONValue itemUidJSON = json.get("itemUid");
			ret.itemUid =  GwtSerDerUtils.STRING.deserialize(itemUidJSON);
		}
		if (!childPropertiesToIgnore.contains("itemExtId")) {
			JSONValue itemExtIdJSON = json.get("itemExtId");
			ret.itemExtId =  GwtSerDerUtils.STRING.deserialize(itemExtIdJSON);
		}
		if (!childPropertiesToIgnore.contains("author")) {
			JSONValue authorJSON = json.get("author");
			ret.author =  GwtSerDerUtils.STRING.deserialize(authorJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.core.container.model.gwt.serder.ChangeLogEntryTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("date")) {
			JSONValue dateJSON = json.get("date");
			ret.date =  GwtSerDerUtils.DATE.deserialize(dateJSON);
		}
		if (!childPropertiesToIgnore.contains("origin")) {
			JSONValue originJSON = json.get("origin");
			ret.origin =  GwtSerDerUtils.STRING.deserialize(originJSON);
		}
		if (!childPropertiesToIgnore.contains("internalId")) {
			JSONValue internalIdJSON = json.get("internalId");
			ret.internalId =  GwtSerDerUtils.LONG.deserialize(internalIdJSON);
		}
		if (!childPropertiesToIgnore.contains("weightSeed")) {
			JSONValue weightSeedJSON = json.get("weightSeed");
			ret.weightSeed =  GwtSerDerUtils.LONG.deserialize(weightSeedJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ChangeLogEntry o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ChangeLogEntry o, JSONObject ret) {

		ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
		ret.put("itemUid",  GwtSerDerUtils.STRING.serialize( o.itemUid ));
		ret.put("itemExtId",  GwtSerDerUtils.STRING.serialize( o.itemExtId ));
		ret.put("author",  GwtSerDerUtils.STRING.serialize( o.author ));
		ret.put("type",  new net.bluemind.core.container.model.gwt.serder.ChangeLogEntryTypeGwtSerDer().serialize( o.type ));
		ret.put("date",  GwtSerDerUtils.DATE.serialize( o.date ));
		ret.put("origin",  GwtSerDerUtils.STRING.serialize( o.origin ));
		ret.put("internalId",  GwtSerDerUtils.LONG.serialize( o.internalId ));
		ret.put("weightSeed",  GwtSerDerUtils.LONG.serialize( o.weightSeed ));
	}

	public void serializeTo(net.bluemind.core.container.model.ChangeLogEntry o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("version")) {
			ret.put("version",  GwtSerDerUtils.LONG.serialize( o.version ));
		}
		if (!childPropertiesToIgnore.contains("itemUid")) {
			ret.put("itemUid",  GwtSerDerUtils.STRING.serialize( o.itemUid ));
		}
		if (!childPropertiesToIgnore.contains("itemExtId")) {
			ret.put("itemExtId",  GwtSerDerUtils.STRING.serialize( o.itemExtId ));
		}
		if (!childPropertiesToIgnore.contains("author")) {
			ret.put("author",  GwtSerDerUtils.STRING.serialize( o.author ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.core.container.model.gwt.serder.ChangeLogEntryTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("date")) {
			ret.put("date",  GwtSerDerUtils.DATE.serialize( o.date ));
		}
		if (!childPropertiesToIgnore.contains("origin")) {
			ret.put("origin",  GwtSerDerUtils.STRING.serialize( o.origin ));
		}
		if (!childPropertiesToIgnore.contains("internalId")) {
			ret.put("internalId",  GwtSerDerUtils.LONG.serialize( o.internalId ));
		}
		if (!childPropertiesToIgnore.contains("weightSeed")) {
			ret.put("weightSeed",  GwtSerDerUtils.LONG.serialize( o.weightSeed ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}