/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerSubscriptionModelGwtSerDer implements GwtSerDer<net.bluemind.core.container.api.ContainerSubscriptionModel> {

	private net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionGwtSerDer parent = new  net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionGwtSerDer();
	public ContainerSubscriptionModelGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.api.ContainerSubscriptionModel deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.api.ContainerSubscriptionModel ret = new net.bluemind.core.container.api.ContainerSubscriptionModel();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerSubscriptionModel ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue containerTypeJSON = json.get("containerType");
		ret.containerType =  GwtSerDerUtils.STRING.deserialize(containerTypeJSON);
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue defaultContainerJSON = json.get("defaultContainer");
		ret.defaultContainer =  GwtSerDerUtils.BOOLEAN.deserialize(defaultContainerJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerSubscriptionModel ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("containerType")) {
			JSONValue containerTypeJSON = json.get("containerType");
			ret.containerType =  GwtSerDerUtils.STRING.deserialize(containerTypeJSON);
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			JSONValue ownerJSON = json.get("owner");
			ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		}
		if (!childPropertiesToIgnore.contains("defaultContainer")) {
			JSONValue defaultContainerJSON = json.get("defaultContainer");
			ret.defaultContainer =  GwtSerDerUtils.BOOLEAN.deserialize(defaultContainerJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.api.ContainerSubscriptionModel o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerSubscriptionModel o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("containerType",  GwtSerDerUtils.STRING.serialize( o.containerType ));
		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("defaultContainer",  GwtSerDerUtils.BOOLEAN.serialize( o.defaultContainer ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerSubscriptionModel o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("containerType")) {
			ret.put("containerType",  GwtSerDerUtils.STRING.serialize( o.containerType ));
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		}
		if (!childPropertiesToIgnore.contains("defaultContainer")) {
			ret.put("defaultContainer",  GwtSerDerUtils.BOOLEAN.serialize( o.defaultContainer ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}