package net.bluemind.mailbox.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.mailbox.api.IMailboxesAsync.class)
public interface IMailboxesPromise  {

	CompletableFuture<java.lang.Long> addDomainRule(net.bluemind.mailbox.api.rules.MailFilterRule rule);

	CompletableFuture<java.lang.Long> addMailboxRule(java.lang.String mailboxUid, net.bluemind.mailbox.api.rules.MailFilterRule rule);

	CompletableFuture<java.lang.Long> addMailboxRuleRelative(java.lang.String mailboxUid, net.bluemind.mailbox.api.rules.RuleMoveRelativePosition position, long anchorId, net.bluemind.mailbox.api.rules.MailFilterRule rule);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> byEmail(java.lang.String email);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> byName(java.lang.String name);

	CompletableFuture<java.util.List<java.lang.String>> byRouting(net.bluemind.mailbox.api.Mailbox.Routing email);

	CompletableFuture<Void> create(java.lang.String uid, net.bluemind.mailbox.api.Mailbox mailbox);

	CompletableFuture<Void> delete(java.lang.String uid);

	CompletableFuture<Void> deleteDomainRule(long id);

	CompletableFuture<Void> deleteMailboxRule(java.lang.String mailboxUid, long id);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>> getComplete(java.lang.String uid);

	CompletableFuture<net.bluemind.mailbox.api.MailFilter> getDomainFilter();

	CompletableFuture<net.bluemind.mailbox.api.rules.MailFilterRule> getDomainRule(long id);

	CompletableFuture<java.util.List<net.bluemind.mailbox.api.rules.MailFilterRule>> getDomainRules();

	CompletableFuture<java.util.List<net.bluemind.core.container.model.acl.AccessControlEntry>> getMailboxAccessControlList(java.lang.String mailboxUid);

	CompletableFuture<net.bluemind.mailbox.api.MailboxConfig> getMailboxConfig(java.lang.String uid);

	CompletableFuture<net.bluemind.mailbox.api.rules.DelegationRule> getMailboxDelegationRule(java.lang.String mailboxUid);

	CompletableFuture<net.bluemind.mailbox.api.MailFilter> getMailboxFilter(java.lang.String mailboxUid);

	CompletableFuture<net.bluemind.mailbox.api.MailFilter.Forwarding> getMailboxForwarding(java.lang.String mailboxUid);

	CompletableFuture<net.bluemind.mailbox.api.MailboxQuota> getMailboxQuota(java.lang.String uid);

	CompletableFuture<net.bluemind.mailbox.api.rules.MailFilterRule> getMailboxRule(java.lang.String mailboxUid, long id);

	CompletableFuture<java.util.List<net.bluemind.mailbox.api.rules.MailFilterRule>> getMailboxRules(java.lang.String mailboxUid);

	CompletableFuture<java.util.List<net.bluemind.mailbox.api.rules.MailFilterRule>> getMailboxRulesByClient(java.lang.String mailboxUid, java.lang.String client);

	CompletableFuture<net.bluemind.mailbox.api.MailFilter.Vacation> getMailboxVacation(java.lang.String mailboxUid);

	CompletableFuture<java.lang.Integer> getUnreadMessagesCount();

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> list();

	CompletableFuture<java.util.List<java.lang.String>> listUids();

	CompletableFuture<Void> moveMailboxRule(java.lang.String mailboxUid, long id, net.bluemind.mailbox.api.rules.RuleMoveDirection direction);

	CompletableFuture<Void> moveMailboxRuleRelative(java.lang.String mailboxUid, long id, net.bluemind.mailbox.api.rules.RuleMoveRelativePosition position, long anchorId);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.mailbox.api.Mailbox>>> multipleGet(java.util.List<java.lang.String> uids);

	CompletableFuture<Void> setDomainFilter(net.bluemind.mailbox.api.MailFilter filter);

	CompletableFuture<Void> setMailboxAccessControlList(java.lang.String mailboxUid, java.util.List<net.bluemind.core.container.model.acl.AccessControlEntry> accessControlEntries);

	CompletableFuture<Void> setMailboxDelegationRule(java.lang.String mailboxUid, net.bluemind.mailbox.api.rules.DelegationRule delegationRule);

	CompletableFuture<Void> setMailboxFilter(java.lang.String mailboxUid, net.bluemind.mailbox.api.MailFilter filter);

	CompletableFuture<Void> setMailboxForwarding(java.lang.String mailboxUid, net.bluemind.mailbox.api.MailFilter.Forwarding forwarding);

	CompletableFuture<Void> setMailboxVacation(java.lang.String mailboxUid, net.bluemind.mailbox.api.MailFilter.Vacation vacation);

	CompletableFuture<Void> update(java.lang.String uid, net.bluemind.mailbox.api.Mailbox mailbox);

	CompletableFuture<Void> updateDomainRule(long id, net.bluemind.mailbox.api.rules.MailFilterRule rule);

	CompletableFuture<Void> updateMailboxRule(java.lang.String mailboxUid, long id, net.bluemind.mailbox.api.rules.MailFilterRule rule);

}