/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailflow.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsExecutionMode extends JavaScriptObject {

	protected JsExecutionMode() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsExecutionMode CONTINUE()
	/*-{
		return "CONTINUE";
	}-*/;

	public static final native JsExecutionMode STOP_AFTER_EXECUTION()
	/*-{
		return "STOP_AFTER_EXECUTION";
	}-*/;

	public static final JsExecutionMode create(net.bluemind.mailflow.api.ExecutionMode value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case CONTINUE:
				return CONTINUE();
			case STOP_AFTER_EXECUTION:
				return STOP_AFTER_EXECUTION();
			default:
				return null;
			}
		}
	}
}