/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailflowRulesEndpointPromise implements net.bluemind.mailflow.api.IMailflowRulesPromise {

	private net.bluemind.mailflow.api.IMailflowRulesAsync impl;

	public MailflowRulesEndpointPromise(net.bluemind.mailflow.api.IMailflowRulesAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor assignment  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, assignment,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailflow.api.MailRuleActionAssignment>> evaluate(net.bluemind.mailflow.common.api.Message message  ) {
		
		CompletableFuture<List<net.bluemind.mailflow.api.MailRuleActionAssignment>> ret = new CompletableFuture<List<net.bluemind.mailflow.api.MailRuleActionAssignment>>();
		AsyncHandler<List<net.bluemind.mailflow.api.MailRuleActionAssignment>> handler = new AsyncHandler<List<net.bluemind.mailflow.api.MailRuleActionAssignment>>() {
			public void success(List<net.bluemind.mailflow.api.MailRuleActionAssignment> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.evaluate(message,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.mailflow.api.MailRuleActionAssignment> getAssignment(String uid  ) {
		
		CompletableFuture<net.bluemind.mailflow.api.MailRuleActionAssignment> ret = new CompletableFuture<net.bluemind.mailflow.api.MailRuleActionAssignment>();
		AsyncHandler<net.bluemind.mailflow.api.MailRuleActionAssignment> handler = new AsyncHandler<net.bluemind.mailflow.api.MailRuleActionAssignment>() {
			public void success(net.bluemind.mailflow.api.MailRuleActionAssignment value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAssignment(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailflow.api.MailActionDescriptor>> listActions() {
		
		CompletableFuture<List<net.bluemind.mailflow.api.MailActionDescriptor>> ret = new CompletableFuture<List<net.bluemind.mailflow.api.MailActionDescriptor>>();
		AsyncHandler<List<net.bluemind.mailflow.api.MailActionDescriptor>> handler = new AsyncHandler<List<net.bluemind.mailflow.api.MailActionDescriptor>>() {
			public void success(List<net.bluemind.mailflow.api.MailActionDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listActions( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailflow.api.MailRuleActionAssignment>> listAssignments() {
		
		CompletableFuture<List<net.bluemind.mailflow.api.MailRuleActionAssignment>> ret = new CompletableFuture<List<net.bluemind.mailflow.api.MailRuleActionAssignment>>();
		AsyncHandler<List<net.bluemind.mailflow.api.MailRuleActionAssignment>> handler = new AsyncHandler<List<net.bluemind.mailflow.api.MailRuleActionAssignment>>() {
			public void success(List<net.bluemind.mailflow.api.MailRuleActionAssignment> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listAssignments( handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.mailflow.api.MailRuleDescriptor>> listRules() {
		
		CompletableFuture<List<net.bluemind.mailflow.api.MailRuleDescriptor>> ret = new CompletableFuture<List<net.bluemind.mailflow.api.MailRuleDescriptor>>();
		AsyncHandler<List<net.bluemind.mailflow.api.MailRuleDescriptor>> handler = new AsyncHandler<List<net.bluemind.mailflow.api.MailRuleDescriptor>>() {
			public void success(List<net.bluemind.mailflow.api.MailRuleDescriptor> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.listRules( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.mailflow.api.MailRuleActionAssignmentDescriptor assignment  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, assignment,  handler);
		return ret;
	}

}
