/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.api.date.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class BmDateTimeGwtSerDer implements GwtSerDer<net.bluemind.core.api.date.BmDateTime> {

	public BmDateTimeGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.api.date.BmDateTime deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.api.date.BmDateTime ret = new net.bluemind.core.api.date.BmDateTime();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.api.date.BmDateTime ret, JSONObject json) {
		JSONValue iso8601JSON = json.get("iso8601");
		ret.iso8601 =  GwtSerDerUtils.STRING.deserialize(iso8601JSON);
		JSONValue timezoneJSON = json.get("timezone");
		ret.timezone =  GwtSerDerUtils.STRING.deserialize(timezoneJSON);
		JSONValue precisionJSON = json.get("precision");
		ret.precision =  new net.bluemind.core.api.date.gwt.serder.BmDateTimePrecisionGwtSerDer().deserialize(precisionJSON);
	}

	public void deserializeTo(net.bluemind.core.api.date.BmDateTime ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("iso8601")) {
			JSONValue iso8601JSON = json.get("iso8601");
			ret.iso8601 =  GwtSerDerUtils.STRING.deserialize(iso8601JSON);
		}
		if (!childPropertiesToIgnore.contains("timezone")) {
			JSONValue timezoneJSON = json.get("timezone");
			ret.timezone =  GwtSerDerUtils.STRING.deserialize(timezoneJSON);
		}
		if (!childPropertiesToIgnore.contains("precision")) {
			JSONValue precisionJSON = json.get("precision");
			ret.precision =  new net.bluemind.core.api.date.gwt.serder.BmDateTimePrecisionGwtSerDer().deserialize(precisionJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.api.date.BmDateTime o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.api.date.BmDateTime o, JSONObject ret) {

		ret.put("iso8601",  GwtSerDerUtils.STRING.serialize( o.iso8601 ));
		ret.put("timezone",  GwtSerDerUtils.STRING.serialize( o.timezone ));
		ret.put("precision",  new net.bluemind.core.api.date.gwt.serder.BmDateTimePrecisionGwtSerDer().serialize( o.precision ));
	}

	public void serializeTo(net.bluemind.core.api.date.BmDateTime o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("iso8601")) {
			ret.put("iso8601",  GwtSerDerUtils.STRING.serialize( o.iso8601 ));
		}
		if (!childPropertiesToIgnore.contains("timezone")) {
			ret.put("timezone",  GwtSerDerUtils.STRING.serialize( o.timezone ));
		}
		if (!childPropertiesToIgnore.contains("precision")) {
			ret.put("precision",  new net.bluemind.core.api.date.gwt.serder.BmDateTimePrecisionGwtSerDer().serialize( o.precision ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}