/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardSecurityGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Security> {

	public VCardSecurityGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Security deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Security ret = new net.bluemind.addressbook.api.VCard.Security();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Security ret, JSONObject json) {
		JSONValue keysJSON = json.get("keys");
		ret.keys =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardSecurityKeyGwtSerDer()).deserialize(keysJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Security ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("keys")) {
			JSONValue keysJSON = json.get("keys");
			ret.keys =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardSecurityKeyGwtSerDer()).deserialize(keysJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Security o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Security o, JSONObject ret) {

		ret.put("keys",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardSecurityKeyGwtSerDer()).serialize( o.keys ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Security o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("keys")) {
			ret.put("keys",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardSecurityKeyGwtSerDer()).serialize( o.keys ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}