/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardQueryGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCardQuery> {

	public VCardQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCardQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCardQuery ret = new net.bluemind.addressbook.api.VCardQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCardQuery ret, JSONObject json) {
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.INT.deserialize(fromJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue queryJSON = json.get("query");
		ret.query =  GwtSerDerUtils.STRING.deserialize(queryJSON);
		JSONValue orderByJSON = json.get("orderBy");
		ret.orderBy =  new net.bluemind.addressbook.api.gwt.serder.VCardQueryOrderByGwtSerDer().deserialize(orderByJSON);
		JSONValue escapeQueryJSON = json.get("escapeQuery");
		ret.escapeQuery =  GwtSerDerUtils.BOOLEAN.deserialize(escapeQueryJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCardQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("from")) {
			JSONValue fromJSON = json.get("from");
			ret.from =  GwtSerDerUtils.INT.deserialize(fromJSON);
		}
		if (!childPropertiesToIgnore.contains("size")) {
			JSONValue sizeJSON = json.get("size");
			ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		}
		if (!childPropertiesToIgnore.contains("query")) {
			JSONValue queryJSON = json.get("query");
			ret.query =  GwtSerDerUtils.STRING.deserialize(queryJSON);
		}
		if (!childPropertiesToIgnore.contains("orderBy")) {
			JSONValue orderByJSON = json.get("orderBy");
			ret.orderBy =  new net.bluemind.addressbook.api.gwt.serder.VCardQueryOrderByGwtSerDer().deserialize(orderByJSON);
		}
		if (!childPropertiesToIgnore.contains("escapeQuery")) {
			JSONValue escapeQueryJSON = json.get("escapeQuery");
			ret.escapeQuery =  GwtSerDerUtils.BOOLEAN.deserialize(escapeQueryJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCardQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCardQuery o, JSONObject ret) {

		ret.put("from",  GwtSerDerUtils.INT.serialize( o.from ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("query",  GwtSerDerUtils.STRING.serialize( o.query ));
		ret.put("orderBy",  new net.bluemind.addressbook.api.gwt.serder.VCardQueryOrderByGwtSerDer().serialize( o.orderBy ));
		ret.put("escapeQuery",  GwtSerDerUtils.BOOLEAN.serialize( o.escapeQuery ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCardQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("from")) {
			ret.put("from",  GwtSerDerUtils.INT.serialize( o.from ));
		}
		if (!childPropertiesToIgnore.contains("size")) {
			ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		}
		if (!childPropertiesToIgnore.contains("query")) {
			ret.put("query",  GwtSerDerUtils.STRING.serialize( o.query ));
		}
		if (!childPropertiesToIgnore.contains("orderBy")) {
			ret.put("orderBy",  new net.bluemind.addressbook.api.gwt.serder.VCardQueryOrderByGwtSerDer().serialize( o.orderBy ));
		}
		if (!childPropertiesToIgnore.contains("escapeQuery")) {
			ret.put("escapeQuery",  GwtSerDerUtils.BOOLEAN.serialize( o.escapeQuery ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}