/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard> {

	public VCardGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard ret = new net.bluemind.addressbook.api.VCard();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard ret, JSONObject json) {
		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.addressbook.api.gwt.serder.VCardKindGwtSerDer().deserialize(kindJSON);
		JSONValue sourceJSON = json.get("source");
		ret.source =  GwtSerDerUtils.STRING.deserialize(sourceJSON);
		JSONValue identificationJSON = json.get("identification");
		ret.identification =  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationGwtSerDer().deserialize(identificationJSON);
		JSONValue deliveryAddressingJSON = json.get("deliveryAddressing");
		ret.deliveryAddressing =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardDeliveryAddressingGwtSerDer()).deserialize(deliveryAddressingJSON);
		JSONValue communicationsJSON = json.get("communications");
		ret.communications =  new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsGwtSerDer().deserialize(communicationsJSON);
		JSONValue organizationalJSON = json.get("organizational");
		ret.organizational =  new net.bluemind.addressbook.api.gwt.serder.VCardOrganizationalGwtSerDer().deserialize(organizationalJSON);
		JSONValue explanatoryJSON = json.get("explanatory");
		ret.explanatory =  new net.bluemind.addressbook.api.gwt.serder.VCardExplanatoryGwtSerDer().deserialize(explanatoryJSON);
		JSONValue securityJSON = json.get("security");
		ret.security =  new net.bluemind.addressbook.api.gwt.serder.VCardSecurityGwtSerDer().deserialize(securityJSON);
		JSONValue relatedJSON = json.get("related");
		ret.related =  new net.bluemind.addressbook.api.gwt.serder.VCardRelatedGwtSerDer().deserialize(relatedJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("kind")) {
			JSONValue kindJSON = json.get("kind");
			ret.kind =  new net.bluemind.addressbook.api.gwt.serder.VCardKindGwtSerDer().deserialize(kindJSON);
		}
		if (!childPropertiesToIgnore.contains("source")) {
			JSONValue sourceJSON = json.get("source");
			ret.source =  GwtSerDerUtils.STRING.deserialize(sourceJSON);
		}
		if (!childPropertiesToIgnore.contains("identification")) {
			JSONValue identificationJSON = json.get("identification");
			ret.identification =  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationGwtSerDer().deserialize(identificationJSON);
		}
		if (!childPropertiesToIgnore.contains("deliveryAddressing")) {
			JSONValue deliveryAddressingJSON = json.get("deliveryAddressing");
			ret.deliveryAddressing =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardDeliveryAddressingGwtSerDer()).deserialize(deliveryAddressingJSON);
		}
		if (!childPropertiesToIgnore.contains("communications")) {
			JSONValue communicationsJSON = json.get("communications");
			ret.communications =  new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsGwtSerDer().deserialize(communicationsJSON);
		}
		if (!childPropertiesToIgnore.contains("organizational")) {
			JSONValue organizationalJSON = json.get("organizational");
			ret.organizational =  new net.bluemind.addressbook.api.gwt.serder.VCardOrganizationalGwtSerDer().deserialize(organizationalJSON);
		}
		if (!childPropertiesToIgnore.contains("explanatory")) {
			JSONValue explanatoryJSON = json.get("explanatory");
			ret.explanatory =  new net.bluemind.addressbook.api.gwt.serder.VCardExplanatoryGwtSerDer().deserialize(explanatoryJSON);
		}
		if (!childPropertiesToIgnore.contains("security")) {
			JSONValue securityJSON = json.get("security");
			ret.security =  new net.bluemind.addressbook.api.gwt.serder.VCardSecurityGwtSerDer().deserialize(securityJSON);
		}
		if (!childPropertiesToIgnore.contains("related")) {
			JSONValue relatedJSON = json.get("related");
			ret.related =  new net.bluemind.addressbook.api.gwt.serder.VCardRelatedGwtSerDer().deserialize(relatedJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard o, JSONObject ret) {

		ret.put("kind",  new net.bluemind.addressbook.api.gwt.serder.VCardKindGwtSerDer().serialize( o.kind ));
		ret.put("source",  GwtSerDerUtils.STRING.serialize( o.source ));
		ret.put("identification",  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationGwtSerDer().serialize( o.identification ));
		ret.put("deliveryAddressing",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardDeliveryAddressingGwtSerDer()).serialize( o.deliveryAddressing ));
		ret.put("communications",  new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsGwtSerDer().serialize( o.communications ));
		ret.put("organizational",  new net.bluemind.addressbook.api.gwt.serder.VCardOrganizationalGwtSerDer().serialize( o.organizational ));
		ret.put("explanatory",  new net.bluemind.addressbook.api.gwt.serder.VCardExplanatoryGwtSerDer().serialize( o.explanatory ));
		ret.put("security",  new net.bluemind.addressbook.api.gwt.serder.VCardSecurityGwtSerDer().serialize( o.security ));
		ret.put("related",  new net.bluemind.addressbook.api.gwt.serder.VCardRelatedGwtSerDer().serialize( o.related ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("kind")) {
			ret.put("kind",  new net.bluemind.addressbook.api.gwt.serder.VCardKindGwtSerDer().serialize( o.kind ));
		}
		if (!childPropertiesToIgnore.contains("source")) {
			ret.put("source",  GwtSerDerUtils.STRING.serialize( o.source ));
		}
		if (!childPropertiesToIgnore.contains("identification")) {
			ret.put("identification",  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationGwtSerDer().serialize( o.identification ));
		}
		if (!childPropertiesToIgnore.contains("deliveryAddressing")) {
			ret.put("deliveryAddressing",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardDeliveryAddressingGwtSerDer()).serialize( o.deliveryAddressing ));
		}
		if (!childPropertiesToIgnore.contains("communications")) {
			ret.put("communications",  new net.bluemind.addressbook.api.gwt.serder.VCardCommunicationsGwtSerDer().serialize( o.communications ));
		}
		if (!childPropertiesToIgnore.contains("organizational")) {
			ret.put("organizational",  new net.bluemind.addressbook.api.gwt.serder.VCardOrganizationalGwtSerDer().serialize( o.organizational ));
		}
		if (!childPropertiesToIgnore.contains("explanatory")) {
			ret.put("explanatory",  new net.bluemind.addressbook.api.gwt.serder.VCardExplanatoryGwtSerDer().serialize( o.explanatory ));
		}
		if (!childPropertiesToIgnore.contains("security")) {
			ret.put("security",  new net.bluemind.addressbook.api.gwt.serder.VCardSecurityGwtSerDer().serialize( o.security ));
		}
		if (!childPropertiesToIgnore.contains("related")) {
			ret.put("related",  new net.bluemind.addressbook.api.gwt.serder.VCardRelatedGwtSerDer().serialize( o.related ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}