/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardExplanatoryGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Explanatory> {

	public VCardExplanatoryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Explanatory deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Explanatory ret = new net.bluemind.addressbook.api.VCard.Explanatory();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Explanatory ret, JSONObject json) {
		JSONValue urlsJSON = json.get("urls");
		ret.urls =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardExplanatoryUrlGwtSerDer()).deserialize(urlsJSON);
		JSONValue categoriesJSON = json.get("categories");
		ret.categories =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).deserialize(categoriesJSON);
		JSONValue noteJSON = json.get("note");
		ret.note =  GwtSerDerUtils.STRING.deserialize(noteJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Explanatory ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("urls")) {
			JSONValue urlsJSON = json.get("urls");
			ret.urls =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardExplanatoryUrlGwtSerDer()).deserialize(urlsJSON);
		}
		if (!childPropertiesToIgnore.contains("categories")) {
			JSONValue categoriesJSON = json.get("categories");
			ret.categories =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).deserialize(categoriesJSON);
		}
		if (!childPropertiesToIgnore.contains("note")) {
			JSONValue noteJSON = json.get("note");
			ret.note =  GwtSerDerUtils.STRING.deserialize(noteJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Explanatory o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Explanatory o, JSONObject ret) {

		ret.put("urls",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardExplanatoryUrlGwtSerDer()).serialize( o.urls ));
		ret.put("categories",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).serialize( o.categories ));
		ret.put("note",  GwtSerDerUtils.STRING.serialize( o.note ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Explanatory o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("urls")) {
			ret.put("urls",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.addressbook.api.gwt.serder.VCardExplanatoryUrlGwtSerDer()).serialize( o.urls ));
		}
		if (!childPropertiesToIgnore.contains("categories")) {
			ret.put("categories",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.tag.api.gwt.serder.TagRefGwtSerDer()).serialize( o.categories ));
		}
		if (!childPropertiesToIgnore.contains("note")) {
			ret.put("note",  GwtSerDerUtils.STRING.serialize( o.note ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}