/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailflow.common.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AssignmentActionMappingGwtSerDer implements GwtSerDer<net.bluemind.mailflow.common.api.AssignmentActionMapping> {

	public AssignmentActionMappingGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailflow.common.api.AssignmentActionMapping deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailflow.common.api.AssignmentActionMapping ret = new net.bluemind.mailflow.common.api.AssignmentActionMapping();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailflow.common.api.AssignmentActionMapping ret, JSONObject json) {
		JSONValue assignmentUidJSON = json.get("assignmentUid");
		ret.assignmentUid =  GwtSerDerUtils.STRING.deserialize(assignmentUidJSON);
		JSONValue actionIdentifierJSON = json.get("actionIdentifier");
		ret.actionIdentifier =  GwtSerDerUtils.STRING.deserialize(actionIdentifierJSON);
		JSONValue actionContextJSON = json.get("actionContext");
		ret.actionContext =  GwtSerDerUtils.STRING.deserialize(actionContextJSON);
	}

	public void deserializeTo(net.bluemind.mailflow.common.api.AssignmentActionMapping ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("assignmentUid")) {
			JSONValue assignmentUidJSON = json.get("assignmentUid");
			ret.assignmentUid =  GwtSerDerUtils.STRING.deserialize(assignmentUidJSON);
		}
		if (!childPropertiesToIgnore.contains("actionIdentifier")) {
			JSONValue actionIdentifierJSON = json.get("actionIdentifier");
			ret.actionIdentifier =  GwtSerDerUtils.STRING.deserialize(actionIdentifierJSON);
		}
		if (!childPropertiesToIgnore.contains("actionContext")) {
			JSONValue actionContextJSON = json.get("actionContext");
			ret.actionContext =  GwtSerDerUtils.STRING.deserialize(actionContextJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailflow.common.api.AssignmentActionMapping o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailflow.common.api.AssignmentActionMapping o, JSONObject ret) {

		ret.put("assignmentUid",  GwtSerDerUtils.STRING.serialize( o.assignmentUid ));
		ret.put("actionIdentifier",  GwtSerDerUtils.STRING.serialize( o.actionIdentifier ));
		ret.put("actionContext",  GwtSerDerUtils.STRING.serialize( o.actionContext ));
	}

	public void serializeTo(net.bluemind.mailflow.common.api.AssignmentActionMapping o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("assignmentUid")) {
			ret.put("assignmentUid",  GwtSerDerUtils.STRING.serialize( o.assignmentUid ));
		}
		if (!childPropertiesToIgnore.contains("actionIdentifier")) {
			ret.put("actionIdentifier",  GwtSerDerUtils.STRING.serialize( o.actionIdentifier ));
		}
		if (!childPropertiesToIgnore.contains("actionContext")) {
			ret.put("actionContext",  GwtSerDerUtils.STRING.serialize( o.actionContext ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}