import { markRaw } from "vue";
import { inject } from "@bluemind/inject";
import { AlertTypes } from "@bluemind/bluetiful";
import SystemAlert from "../components/alerts/SystemAlert";

export function useAnnouncementsPersistence(systemAlertService) {
    const { dispatchSystemAlert } = systemAlertService;
    let userAnnouncementsPersistence = [];

    async function annoucementsPersistence() {
        userAnnouncementsPersistence = await inject("UserAnnouncementsPersistence").get();
        userAnnouncementsPersistence.forEach((announcement, index) => {
            const alert = {
                type: getAlertType(announcement.kind),
                uid: index,
                renderer: { component: markRaw(SystemAlert), props: { payload: announcement } }
            };
            dispatchSystemAlert(alert);
        });
    }

    return { annoucementsPersistence };
}

function getAlertType(kind) {
    switch (kind) {
        case "Error":
            return AlertTypes.ERROR;
        case "Info":
            return AlertTypes.INFO;
        case "Warn":
            return AlertTypes.WARNING;
    }
}
