import { markRaw } from "vue";
import Roles from "@bluemind/roles";

import PrefReadMoreLabel from "../fields/PrefReadMoreLabel.vue";
import listStyleCompact from "../../../../assets/list-style-compact.png";
import listStyleFull from "../../../../assets/list-style-full.png";
import listStyleNormal from "../../../../assets/list-style-normal.png";
import threadSettingImageOn from "../../../../assets/setting-thread-on.svg?raw";
import threadSettingImageOff from "../../../../assets/setting-thread-off.svg?raw";

import { mapExtensions } from "@bluemind/extensions";

export default function (vueI18N) {
    const mail = mapExtensions("net.bluemind.webapp", ["application"]).application?.find(
        ({ $bundle }) => $bundle === "net.bluemind.webapp.mail.js"
    );
    return {
        id: "mail",
        name: vueI18N.t("common.application.webmail"),
        icon: mail?.icon,
        priority: mail?.priority,
        visible: { name: "RoleCondition", args: [Roles.HAS_MAIL] },
        categories: [
            main(vueI18N),
            myMailbox(vueI18N),
            otherMailboxes(vueI18N),
            filters(vueI18N),
            messageComposing(vueI18N),
            advanced(vueI18N)
        ]
    };
}

function main(vueI18N) {
    return {
        id: "main",
        name: vueI18N.t("common.general"),
        icon: "tool",
        groups: [
            {
                id: "thread",
                name: vueI18N.t("preferences.mail.thread"),
                disabled: { name: "StoreFieldCondition", args: ["mail.main.thread.field", "unavailable"] },
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefFieldChoice",
                            options: {
                                setting: "mail_thread",
                                default: "false",
                                needReload: true,
                                preview: true,
                                choices: [
                                    {
                                        label: vueI18N.t("preferences.mail.thread.enable"),
                                        value: "true",
                                        svg: threadSettingImageOn
                                    },
                                    {
                                        label: vueI18N.t("preferences.mail.thread.disable"),
                                        value: "false",
                                        svg: threadSettingImageOff
                                    }
                                ]
                            }
                        }
                    },
                    {
                        id: "thread",
                        disabled: { name: "StoreFieldCondition", args: ["mail.main.thread.field", "false"] },
                        component: {
                            name: "PrefThread",
                            options: {
                                needReload: false,
                                autosave: true
                            }
                        }
                    }
                ]
            },
            {
                id: "list",
                name: vueI18N.t("preferences.mail.message.list.display"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefFieldChoice",
                            options: {
                                setting: "mail_message_list_style",
                                default: "normal",
                                autosave: true,
                                preview: true,
                                choices: [
                                    {
                                        label: vueI18N.t("preferences.mail.message.list.display.full"),
                                        value: "full",
                                        img: listStyleFull
                                    },
                                    {
                                        label: vueI18N.t("preferences.mail.message.list.display.normal"),
                                        value: "normal",
                                        img: listStyleNormal
                                    },
                                    {
                                        label: vueI18N.t("preferences.mail.message.list.display.compact"),
                                        value: "compact",
                                        img: listStyleCompact
                                    }
                                ]
                            }
                        }
                    }
                ]
            },
            {
                id: "purge_on_logout",
                name: vueI18N.t("preferences.mail.logout"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefFieldSwitch",
                            options: {
                                setting: "logout_purge",
                                default: "false",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.logout.empty.trash")
                            }
                        }
                    }
                ]
            },
            {
                id: "read_and_delivery_receipts",
                name: vueI18N.t("preferences.mail.receipts"),
                fields: [
                    {
                        id: "info",
                        component: {
                            name: "PrefFieldInfo",
                            options: {
                                lines: [
                                    vueI18N.t("preferences.mail.receipts.info.delivery"),
                                    vueI18N.t("preferences.mail.receipts.info.read")
                                ],
                                readMoreLink:
                                    "https://doc.bluemind.net/current/guide_de_l_utilisateur/la_messagerie/envoyer_des_messages/demander_des_accuses"
                            }
                        }
                    },
                    {
                        id: "ask",
                        component: {
                            name: "PrefFieldLabel",
                            options: {
                                label: vueI18N.t("preferences.mail.receipts.ask")
                            }
                        }
                    },
                    {
                        id: "ask_delivery",
                        component: {
                            name: "PrefFieldCheck",
                            options: {
                                setting: "always_ask_delivery_receipt",
                                default: "false",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.receipts.ask.delivery")
                            }
                        }
                    },
                    {
                        id: "ask_read",
                        component: {
                            name: "PrefFieldCheck",
                            options: {
                                setting: "always_ask_read_receipt",
                                default: "false",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.receipts.ask.read")
                            }
                        }
                    },
                    {
                        id: "answer_read_confirmation",
                        component: {
                            name: "PrefFieldLabel",
                            options: {
                                label: vueI18N.t("preferences.mail.receipts.answer_read_confirmation")
                            }
                        }
                    },
                    {
                        id: "answer_read_confirmation_choice",
                        component: {
                            name: "PrefFieldChoice",
                            options: {
                                setting: "answer_read_confirmation",
                                default: "ask",
                                autosave: true,
                                choices: [
                                    {
                                        label: vueI18N.t("preferences.mail.receipts.answer_read_confirmation.never"),
                                        value: "never"
                                    },
                                    {
                                        label: vueI18N.t("preferences.mail.receipts.answer_read_confirmation.ask"),
                                        value: "ask"
                                    },
                                    {
                                        label: vueI18N.t("preferences.mail.receipts.answer_read_confirmation.always"),
                                        value: "always"
                                    }
                                ]
                            }
                        }
                    }
                ]
            },
            {
                id: "remote_images",
                name: vueI18N.t("preferences.mail.remote.images"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefFieldSwitch",
                            options: {
                                setting: "trust_every_remote_content",
                                default: "false",
                                autosave: true,
                                additional_component: "PrefRemoteImage",
                                label: vueI18N.t("preferences.mail.remote.images.trust")
                            }
                        }
                    },
                    {
                        id: "help",
                        component: { name: "PrefRemoteImage" }
                    }
                ]
            },
            {
                id: "show_quota",
                name: vueI18N.t("preferences.mail.quota"),
                fields: [
                    {
                        id: "field",
                        visible: {
                            name: "QuotaCondition.hasLimit"
                        },
                        component: {
                            name: "PrefFieldSwitch",
                            options: {
                                setting: "always_show_quota",
                                default: "false",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.quota.always.display")
                            }
                        }
                    },
                    {
                        id: "usage",
                        component: { name: "PrefAlwaysShowQuota" }
                    }
                ]
            },
            {
                id: "automatic_reply",
                name: vueI18N.t("preferences.mail.automatic_reply"),
                visible: { name: "RoleCondition", args: [Roles.SELF_CHANGE_MAILBOX_FILTER] },
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefAutomaticReply" }
                    }
                ]
            },
            {
                id: "forwarding",
                name: vueI18N.t("preferences.mail.emails_forwarding"),
                visible: { name: "RoleCondition", args: [Roles.SELF_CHANGE_MAILBOX_FILTER] },
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefEmailsForwarding" }
                    }
                ]
            },
            {
                id: "default_app",
                name: vueI18N.t("preferences.mail.mailto_links"),
                visible: { name: "RoleCondition", args: [Roles.HAS_MAIL_WEBAPP] },
                fields: [{ id: "default_app_action", component: { name: "PrefMailtoLinks" } }]
            }
        ]
    };
}

function myMailbox(vueI18N) {
    return {
        id: "my_mailbox",
        name: vueI18N.t("common.my_mailbox"),
        icon: "mail-user",
        groups: [
            {
                id: "offline",
                name: vueI18N.t("preferences.mail.my_mailbox.offline_mode"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefOfflineMode"
                        }
                    }
                ]
            },
            {
                id: "shares",
                name: vueI18N.t("preferences.mail.my_mailbox.my_shares"),
                fields: [{ id: "field", component: { name: "PrefManageMyMailboxShares" } }]
            }
        ]
    };
}

function otherMailboxes(vueI18N) {
    return {
        id: "other_mailboxes",
        name: vueI18N.t("common.other_mailboxes"),
        icon: "mail-3dots",
        groups: [
            {
                id: "group",
                name: vueI18N.t("common.other_mailboxes"),
                fields: [{ id: "field", component: { name: "PrefManageOtherMailboxes" } }]
            }
        ]
    };
}

function filters(vueI18N) {
    return {
        id: "filters",
        name: vueI18N.t("preferences.mail.filters"),
        icon: "funnel",
        groups: [
            {
                id: "filter",
                name: vueI18N.t("preferences.mail.filters"),
                description: vueI18N.t("preferences.mail.filters.desc"),

                fields: [
                    {
                        id: "domain_filters",
                        visible: { name: "RoleCondition", args: [Roles.READ_DOMAIN_FILTERS] },
                        component: { name: "PrefDomainFilterRules" }
                    },
                    {
                        id: "my_filters",
                        visible: { name: "RoleCondition", args: [Roles.SELF_CHANGE_MAILBOX_FILTER] },
                        component: {
                            name: "PrefMyFilterRules",
                            options: { autosave: true }
                        }
                    }
                ]
            }
        ]
    };
}

function messageComposing(vueI18N) {
    return {
        id: "message_composing",
        name: vueI18N.t("preferences.mail.compose.title"),
        icon: "pencil",
        groups: [
            {
                id: "main",
                name: vueI18N.t("common.composing"),
                fields: [
                    {
                        id: "mail_compose_in_new_window",
                        component: {
                            name: "PrefFieldSwitch",
                            options: {
                                setting: "mail_compose_in_new_window",
                                default: "false",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.compose.in_new_window")
                            }
                        }
                    },
                    {
                        id: "default_font",
                        component: {
                            name: "PrefComposerDefaultFont",
                            options: {
                                setting: "composer_default_font",
                                default: "montserrat",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.compose.default_font")
                            }
                        }
                    },
                    {
                        id: "always_show_reply_to",
                        component: {
                            name: "PrefFieldSwitch",
                            options: {
                                setting: "always_show_reply_to",
                                default: "false",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.compose.always_show_reply_to")
                            }
                        }
                    },
                    {
                        id: "always_show_from",
                        component: {
                            name: "PrefFieldSwitch",
                            options: {
                                setting: "always_show_from",
                                default: "false",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.identities.always_show_from")
                            }
                        }
                    },
                    {
                        id: "automatic",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                setting: "auto_select_from",
                                default: "never",
                                autosave: true,
                                label: {
                                    component: markRaw(PrefReadMoreLabel),
                                    options: {
                                        href: "https://doc.bluemind.net/release/5.4/guide_de_l_utilisateur/la_messagerie/parametrer_la_messagerie/gerer_les_identites_du_compte",
                                        label: vueI18N.t("preferences.mail.identities.auto_select.label")
                                    }
                                },
                                headerLabel: vueI18N.t("preferences.mail.identities.auto_select.label"),
                                choices: [
                                    { text: vueI18N.t("common.never"), value: "never" },
                                    {
                                        text: vueI18N.t("preferences.mail.identities.auto_select.only_for_replies"),
                                        value: "only_replies"
                                    },
                                    {
                                        text: vueI18N.t("preferences.mail.identities.auto_select.replies_and_new"),
                                        value: "replies_and_new_messages"
                                    }
                                ]
                            }
                        }
                    }
                ]
            },
            {
                id: "identities",
                name: vueI18N.t("common.identities"),
                disabled: {
                    name: "RoleCondition.none",
                    args: [Roles.MANAGE_USER_MAIL_IDENTITIES, Roles.SELF_CHANGE_MAIL_IDENTITIES]
                },
                fields: [
                    {
                        id: "manage",
                        component: { name: "PrefManageIdentities" }
                    }
                ]
            },
            {
                id: "signature",
                name: vueI18N.t("common.signature"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefFieldSwitch",
                            options: {
                                setting: "insert_signature",
                                default: "true",
                                autosave: true,
                                label: vueI18N.t("preferences.mail.signature.insert")
                            }
                        }
                    }
                ]
            }
        ]
    };
}

function advanced(vueI18N) {
    return {
        id: "advanced",
        name: vueI18N.t("common.advanced"),
        icon: "plus",
        priority: -1,
        groups: [
            {
                id: "application",
                name: vueI18N.t("preferences.mail.advanced.switch.title"),
                visible: { name: "RoleCondition.every", args: [Roles.HAS_WEBMAIL, Roles.HAS_MAIL_WEBAPP] },
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefFieldSwitch",
                            options: {
                                setting: "mail-application",
                                label: vueI18N.t("preferences.mail.advanced.switch.label"),
                                checkedValue: "mail-webapp",
                                uncheckedValue: "webmail",
                                needReload: true
                            }
                        }
                    },
                    {
                        id: "image",
                        disabled: {
                            name: "StoreFieldCondition",
                            args: ["mail.advanced.application.field", "webmail"]
                        },
                        component: {
                            name: "PrefSwitchWebmail"
                        }
                    }
                ]
            },
            {
                id: "recipient-autocomplete",
                name: vueI18N.t("preferences.mail.advanced.recipient_autocomplete.title"),
                visible: { name: "RoleCondition", args: [Roles.HAS_MAIL_WEBAPP] },
                fields: [{ id: "reset", component: { name: "PrefDeleteRecipientPriorities" } }]
            }
        ]
    };
}
