import { markRaw } from "vue";
import { isAvailable } from "@bluemind/commons/utils/notification";
import { AvailableTimeFormats, AvailableDateFormats, AvailablesTimezones } from "@bluemind/date";
import { AvailableLanguages } from "@bluemind/i18n";
import Roles from "@bluemind/roles";
import PrefFieldTimezoneLabel from "../fields/customs/PrefFieldTimezoneLabel.vue";
import bluemindLogo from "../../../../assets/bluemind-logo.svg?raw";
import themeSystem from "../../../../assets/theme-system.png";
import themeLight from "../../../../assets/theme-light.png";
import themeDark from "../../../../assets/theme-dark.png";

export default function (vueI18N) {
    return {
        id: "my_account",
        name: vueI18N?.t("common.my_account"),
        icon: {
            svg: bluemindLogo
        },
        priority: Number.MAX_SAFE_INTEGER,
        categories: [
            main(vueI18N),
            security(vueI18N),
            cti(vueI18N),
            delegates(vueI18N),
            advanced(vueI18N),
            externalAccounts(vueI18N)
        ]
    };
}

function main(vueI18N) {
    const availableDefaultApps = [
        { text: vueI18N?.t("common.application.webmail"), value: "/webapp/mail/" },
        { text: vueI18N?.t("common.application.calendar"), value: "/cal/" }
    ];
    return {
        id: "main",
        name: vueI18N?.t("common.general"),
        icon: "tool",
        groups: [
            {
                id: "localisation",
                name: vueI18N?.t("common.localisation"),
                fields: [
                    {
                        id: "lang",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                choices: AvailableLanguages,
                                label: vueI18N?.t("preferences.general.lang"),
                                setting: "lang",
                                needReload: true
                            }
                        }
                    },

                    {
                        id: "dateformat",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                choices: AvailableDateFormats,
                                label: vueI18N?.t("preferences.general.date_format"),
                                setting: "date",
                                autosave: true
                            }
                        }
                    },
                    {
                        id: "timeformat",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                choices: AvailableTimeFormats,
                                label: vueI18N?.t("preferences.general.time_format"),
                                setting: "timeformat",
                                autosave: true
                            }
                        }
                    },
                    {
                        id: "timezone",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                choices: AvailablesTimezones,
                                label: {
                                    component: markRaw(PrefFieldTimezoneLabel),
                                    options: {
                                        label: vueI18N.t("preferences.general.timezone")
                                    }
                                },
                                headerLabel: vueI18N.t("preferences.general.timezone"),
                                filter: true,
                                setting: "timezone",
                                needReload: true
                            }
                        }
                    },
                    {
                        id: "timezone_difference_reminder",
                        component: {
                            name: "PrefFieldCheck",
                            options: {
                                setting: "timezone_difference_reminder",
                                default: "true",
                                autosave: true,
                                needReload: true,
                                label: vueI18N.t("preferences.calendar.main.timezone_difference_reminder")
                            }
                        }
                    }
                ]
            },
            {
                id: "default_app",
                name: vueI18N?.t("preferences.general.default_application"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefFieldSelect",
                            options: {
                                choices: availableDefaultApps,
                                headerLabel: vueI18N?.t("preferences.general.default_application"),
                                setting: "default_app",
                                needLogout: true
                            }
                        }
                    }
                ]
            },
            {
                id: "theme",
                name: vueI18N?.t("preferences.general.theme"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefFieldChoice",
                            options: {
                                setting: "theme",
                                autosave: true,
                                preview: true,
                                choices: [
                                    {
                                        label: vueI18N?.t("preferences.general.theme.system"),
                                        value: "system",
                                        img: themeSystem
                                    },
                                    {
                                        label: vueI18N?.t("preferences.general.theme.light"),
                                        value: "light",
                                        img: themeLight
                                    },
                                    {
                                        label: vueI18N?.t("preferences.general.theme.dark"),
                                        value: "dark",
                                        img: themeDark
                                    }
                                ],
                                default: "system"
                            }
                        }
                    }
                ]
            },
            {
                id: "tags",
                name: vueI18N?.t("preferences.general.tags"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefTags",
                            options: { autosave: true }
                        }
                    }
                ]
            }
        ]
    };
}

function advanced(vueI18N) {
    return {
        id: "advanced",
        name: vueI18N?.t("common.advanced"),
        icon: "plus",
        priority: -1,
        groups: [
            {
                id: "local_data",
                name: vueI18N?.t("preferences.advanced.reinit_local_data"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefResetLocalData",
                            options: {
                                text: vueI18N?.t("common.action.reset"),
                                label: vueI18N?.t("preferences.advanced.reinit_local_data.explanations")
                            }
                        }
                    }
                ]
            },
            {
                id: "notification",
                name: vueI18N?.t("preferences.advanced.notifications"),
                visible: isAvailable(),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefEnableNotifications" }
                    }
                ]
            }
        ]
    };
}

function security(vueI18N) {
    return {
        id: "security",
        name: vueI18N?.t("common.security"),
        icon: "key",
        groups: [
            {
                id: "password",
                name: vueI18N?.t("common.password"),
                disabled: {
                    name: "RoleCondition.none",
                    args: [Roles.SELF_CHANGE_PASSWORD]
                },

                fields: [
                    {
                        id: "field",
                        component: { name: "PrefPassword" }
                    }
                ]
            },
            {
                id: "api_keys",
                name: vueI18N?.t("preferences.security.api_key"),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefAPIKey" }
                    }
                ]
            }
        ]
    };
}

function cti(vueI18N) {
    return {
        id: "cti",
        name: vueI18N?.t("common.telephony"),
        icon: "phone",
        visible: { name: "RoleCondition.every", args: [Roles.HAS_CTI] },
        groups: [
            {
                id: "status",
                name: vueI18N?.t("common.telephony"),
                fields: [
                    {
                        id: "field",
                        component: {
                            name: "PrefIMSetPhonePresence",
                            options: {
                                setting: "im_set_phone_presence"
                            }
                        }
                    }
                ]
            }
        ]
    };
}

function externalAccounts(vueI18N) {
    return {
        id: "external_accounts",
        name: vueI18N?.t("preferences.account.external_accounts"),
        icon: "user",
        visible: { name: "RoleCondition", args: [Roles.SELF_MANAGE_EXTERNAL_ACCOUNT] },
        groups: [
            {
                id: "creation",
                name: vueI18N?.t("preferences.account.external_accounts.creation"),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefExtAccountCreation" }
                    }
                ]
            },
            {
                id: "list",
                name: vueI18N?.t("preferences.account.external_accounts.list"),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefExtAccountList", options: { autosave: true } }
                    }
                ]
            }
        ]
    };
}

function delegates(vueI18N) {
    return {
        id: "delegates",
        name: vueI18N?.t("preferences.account.delegates"),
        icon: "user-hierarchy",
        visible: { name: "RoleCondition", args: [Roles.HAS_MAIL] },
        groups: [
            {
                id: "group",
                name: vueI18N?.t("preferences.account.delegates"),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefDelegates" }
                    }
                ]
            }
        ]
    };
}
