import { markRaw } from "vue";
import { DefaultAlert } from "@bluemind/alert.store";
import { type AlertMessage, AlertType, AlertTypes } from "@bluemind/bluetiful";

function saveAlert(type: AlertType): AlertMessage {
    return {
        uid: "SAVE",
        type,
        renderer: {
            component: markRaw(DefaultAlert),
            props: { name: "preferences.SAVE" }
        }
    };
}

export const SAVE_SUCCESS_ALERT = saveAlert(AlertTypes.SUCCESS);
export const SAVE_ERROR_ALERT = saveAlert(AlertTypes.ERROR);
