package net.bluemind.webmodule.project.vite.internal;

import java.util.Collections;
import java.util.List;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

public class ManifestChunk {
	/**
	 * Chunk key in manifest
	 */
	String key;
	/**
	 * Chunk input file.
	 */
	String src;
	/**
	 * When chunk input property is in object form, name is the key of the input
	 * entry, if not name is equal to input filename.
	 * 
	 * @see <a href="https://rollupjs.org/configuration-options/#input"> Rollup
	 *      documentation </a>
	 */
	String name;
	/**
	 * Chunk output (generated) file
	 */
	String file;
	/**
	 * List of the css assets generated for this chunk
	 */
	List<String> css;
	/**
	 * All others assets generated for this chunk
	 */
	List<String> assets;
	/**
	 * Is this file an entry point of vite compilation config
	 */
	boolean isEntry;
	/**
	 * Is this file generated from a dynamic import
	 */
	boolean isDynamicEntry;
	/**
	 * Common imports
	 */
	List<String> imports;
	/**
	 * Lazy loading imports
	 */
	List<String> dynamicImports;

	protected ManifestChunk(String key, JsonObject source) {
		this.key = key;
		src = source.getString("src");
		name = source.getString("name");
		file = source.getString("file");
		css = toList(source.getJsonArray("css"));
		assets = toList(source.getJsonArray("assets"));
		isEntry = toBoolean(source.getBoolean("isEntry"));
		isDynamicEntry = toBoolean(source.getBoolean("isDynamicEntry"));
		imports = toList(source.getJsonArray("imports"));
		dynamicImports = toList(source.getJsonArray("dynamicImports"));

	}

	private boolean toBoolean(Boolean bool) {
		return bool != null && bool.booleanValue();
	}

	@SuppressWarnings("unchecked")
	private static List<String> toList(JsonArray array) {
		return array == null ? Collections.emptyList() : array.getList();
	}
}